/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.xseries.profiles.objects.transformer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nl.aurorion.blockregen.xseries.profiles.gameprofile.MojangGameProfile;
import nl.aurorion.blockregen.xseries.profiles.objects.Profileable;
import nl.aurorion.blockregen.xseries.profiles.objects.transformer.ProfileTransformer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TransformableProfile
implements Profileable {
    private final Profileable profileable;
    private final TransformationSequence transformers;

    @ApiStatus.Internal
    public TransformableProfile(Profileable profileable, List<ProfileTransformer> transformers) {
        this.profileable = profileable;
        this.transformers = new TransformationSequence(profileable, transformers);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public Profileable transform(ProfileTransformer ... transformers) {
        ArrayList<ProfileTransformer> transformersList = new ArrayList<ProfileTransformer>(this.transformers.transformers.length + transformers.length);
        transformersList.addAll(Arrays.stream(this.transformers.transformers).map(x -> ((TransformationSequence.TransformedProfileCache)x).transformer).collect(Collectors.toList()));
        transformersList.addAll(Arrays.asList(transformers));
        return new TransformableProfile(this.profileable, transformersList);
    }

    @Override
    public MojangGameProfile getProfile() {
        this.transformers.profile = this.profileable.getProfile();
        if (this.transformers.profile == null) {
            return null;
        }
        for (TransformationSequence.TransformedProfileCache transformer : this.transformers.transformers) {
            transformer.transform();
        }
        return this.transformers.profile;
    }

    private static final class TransformationSequence {
        private final Profileable profileable;
        @Nullable
        private MojangGameProfile profile;
        private boolean expired;
        private final TransformedProfileCache[] transformers;

        private TransformationSequence(Profileable profileable, List<ProfileTransformer> transformers) {
            this.profileable = profileable;
            this.transformers = (TransformedProfileCache[])transformers.stream().map(x$0 -> new TransformedProfileCache((ProfileTransformer)x$0)).toArray(TransformedProfileCache[]::new);
        }

        private final class TransformedProfileCache {
            @Nullable
            private final ProfileTransformer transformer;
            @Nullable
            private MojangGameProfile cacheProfile;

            private TransformedProfileCache(ProfileTransformer transformer) {
                this.transformer = transformer;
            }

            private void transform() {
                if (this.cacheProfile != null && this.transformer.canBeCached()) {
                    if (!TransformationSequence.this.expired) {
                        TransformationSequence.this.profile = this.cacheProfile;
                        return;
                    }
                } else {
                    TransformationSequence.this.expired = true;
                }
                this.cacheProfile = this.transformer.transform(TransformationSequence.this.profileable, TransformationSequence.this.profile);
                TransformationSequence.this.profile = this.cacheProfile;
            }
        }
    }
}

