/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.command;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.Message;
import nl.aurorion.blockregen.event.struct.PresetEvent;
import nl.aurorion.blockregen.preset.BlockPreset;
import nl.aurorion.blockregen.regeneration.struct.RegenerationProcess;
import nl.aurorion.blockregen.region.RegionSelection;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.region.struct.RegenerationRegion;
import nl.aurorion.blockregen.region.struct.RegenerationWorld;
import nl.aurorion.blockregen.util.Colors;
import nl.aurorion.blockregen.util.Locations;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Commands
implements CommandExecutor {
    private static final String HELP = "&8&m        &r &3BlockRegen &f%version% &8&m        &r\n&3/%label% reload &8- &7Reload the plugin.\n&3/%label% debug &8- &7Turn on debug. Receive debug messages in chat.\n&3/%label% bypass &8- &7Bypass block regeneration.\n&3/%label% check &8- &7Check the correct material name to use. Just hit a block.\n&3/%label% tools &8- &7Gives you tools for regions.\n&3/%label% regions &8- &7List regions.\n&3/%label% region set <region> &8- &7Create a region from your selection.\n&3/%label% region world <region> <worldName> &8- &7Create a region for the world.\n&3/%label% region all <region> &8- &7Switch 'all presets' mode.\n&3/%label% region add <region> <preset> &8- &7Add a preset to the region.\n&3/%label% region remove <region> <preset> &8- &7Remove a preset from region.\n&3/%label% region clear <region> &8- &7Clear all presets from the region.\n&3/%label% region priority <region> <priority> &8- &7Set the priority of the region.\n&3/%label% region copy <region-from> <region-to> &8- &7Copy configured presets from one region to another.\n&3/%label% region delete <region> &8- &7Delete a region.\n&3/%label% regen (-p <preset>) (-r <region>) (-w <world>) &8- &7Regenerate presets based on argument switches.\n&3/%label% events &8- &7Event management.\n&3/%label% stats &8- &7Print statistics about currently running regeneration processes.\n&3/%label% discord &8- &7BlockRegen discord invite. Ask for support there.";
    private final BlockRegenPlugin plugin;

    public Commands(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    private void sendHelp(CommandSender sender, String label) {
        sender.sendMessage(Colors.color(HELP.replace("%version%", this.plugin.getDescription().getVersion()).replace("%label%", label)));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender, label);
            return false;
        }
        block14 : switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("blockregen.reload")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                this.plugin.reload(sender);
                break;
            }
            case "bypass": {
                if (this.checkConsole(sender)) {
                    return false;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("blockregen.bypass")) {
                    Message.NO_PERM.send(player);
                    return false;
                }
                if (this.plugin.getRegenerationManager().switchBypass(player)) {
                    Message.BYPASS_ON.send(player);
                    break;
                }
                Message.BYPASS_OFF.send(player);
                break;
            }
            case "check": {
                if (this.checkConsole(sender)) {
                    return false;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("blockregen.check")) {
                    Message.NO_PERM.send(player);
                    return false;
                }
                if (this.plugin.getRegenerationManager().switchDataCheck(player)) {
                    Message.DATA_CHECK_ON.send(player);
                    break;
                }
                Message.DATA_CHECK_OFF.send(player);
                break;
            }
            case "tools": {
                if (this.checkConsole(sender)) {
                    return false;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("blockregen.tools")) {
                    Message.NO_PERM.send(player);
                    return false;
                }
                this.giveTools(player);
                break;
            }
            case "regions": {
                if (this.checkConsole(sender)) {
                    return false;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("blockregen.region")) {
                    Message.NO_PERM.send(player);
                    return false;
                }
                if (args.length > 1) {
                    Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s regions", label)));
                    return false;
                }
                this.listRegions(sender);
                break;
            }
            case "region": {
                if (this.checkConsole(sender)) {
                    return false;
                }
                Player player = (Player)sender;
                if (!player.hasPermission("blockregen.region")) {
                    Message.NO_PERM.send(player);
                    return false;
                }
                if (args.length == 1) {
                    this.sendHelp(sender, label);
                    return false;
                }
                switch (args[1].toLowerCase()) {
                    case "list": {
                        if (args.length > 2) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region list", label)));
                            return false;
                        }
                        this.listRegions(sender);
                        return false;
                    }
                    case "world": {
                        if (args.length > 4) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region world <name> <worldName>", label)));
                            return false;
                        }
                        if (args.length < 4) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region world <name> <worldName>", label)));
                            return false;
                        }
                        if (this.plugin.getRegionManager().exists(args[2])) {
                            Message.DUPLICATED_REGION.send(player);
                            return false;
                        }
                        for (RegenerationArea area : this.plugin.getRegionManager().getLoadedAreas()) {
                            RegenerationWorld world;
                            if (!(area instanceof RegenerationWorld) || !(world = (RegenerationWorld)area).getWorldName().equals(args[3])) continue;
                            Message.DUPLICATED_WORLD_REGION.send(player);
                            return false;
                        }
                        RegenerationWorld area = this.plugin.getRegionManager().createWorld(args[2], args[3]);
                        this.plugin.getRegionManager().addArea(area);
                        Message.REGION_FROM_WORLD.mapAndSend(player, str -> str.replace("%region%", args[2]).replace("%world%", args[3]));
                        break block14;
                    }
                    case "priority": {
                        int priority;
                        if (args.length > 4) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region priority <name> <priority>", label)));
                            return false;
                        }
                        if (args.length < 4) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region priority <name> <priority>", label)));
                            return false;
                        }
                        if (!this.plugin.getRegionManager().exists(args[2])) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        try {
                            priority = Integer.parseInt(args[3]);
                        }
                        catch (NumberFormatException e2) {
                            Message.ARGUMENT_NOT_A_NUMBER.mapAndSend(player, str -> str.replace("%arg%", "priority").replace("%value%", args[3]));
                            break block14;
                        }
                        RegenerationArea area = this.plugin.getRegionManager().getArea(args[2]);
                        area.setPriority(priority);
                        this.plugin.getRegionManager().sort();
                        Message.REGION_PRIORITY_CHANGED.mapAndSend(player, str -> str.replace("%region%", args[2]).replace("%priority%", args[3]));
                        break block14;
                    }
                    case "set": {
                        RegionSelection selection;
                        if (args.length > 3) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region set <name>", label)));
                            return false;
                        }
                        if (args.length < 3) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region set <name>", label)));
                            return false;
                        }
                        if (this.plugin.getRegionManager().exists(args[2])) {
                            Message.DUPLICATED_REGION.send(player);
                            return false;
                        }
                        if (this.plugin.getVersionManager().getWorldEditProvider() != null) {
                            selection = this.plugin.getVersionManager().getWorldEditProvider().createSelection(player);
                            if (selection == null) {
                                Message.NO_SELECTION.send(player);
                                return false;
                            }
                        } else {
                            selection = this.plugin.getRegionManager().getSelection(player);
                        }
                        if (!this.plugin.getRegionManager().finishSelection(args[2], selection)) {
                            Message.COULD_NOT_CREATE_REGION.send(player);
                            return false;
                        }
                        Message.SET_REGION.mapAndSend(player, str -> str.replace("%region%", args[2]));
                        return false;
                    }
                    case "delete": {
                        if (args.length > 3) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region delete <name>", label)));
                            return false;
                        }
                        if (args.length < 3) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region delete <name>", label)));
                            return false;
                        }
                        if (!this.plugin.getRegionManager().exists(args[2])) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        this.plugin.getRegionManager().removeArea(args[2]);
                        Message.REMOVE_REGION.send(player);
                        return false;
                    }
                    case "all": {
                        if (args.length > 3) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region all <name>", label)));
                            return false;
                        }
                        if (args.length < 3) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region all <name>", label)));
                            return false;
                        }
                        RegenerationArea region = this.plugin.getRegionManager().getArea(args[2]);
                        if (region == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        Message.SET_ALL.mapAndSend(player, str -> String.format(str, region.switchAll() ? "&aall" : "&cnot all"));
                        return false;
                    }
                    case "add": {
                        if (args.length > 4) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region add <name> <preset>", label)));
                            return false;
                        }
                        if (args.length < 4) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region add <name> <preset>", label)));
                            return false;
                        }
                        RegenerationArea region = this.plugin.getRegionManager().getArea(args[2]);
                        if (region == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        BlockPreset preset = this.plugin.getPresetManager().getPreset(args[3]);
                        if (preset == null) {
                            Message.INVALID_PRESET.mapAndSend(player, str -> str.replace("%preset%", args[3]));
                            return false;
                        }
                        if (region.hasPreset(preset.getName())) {
                            Message.HAS_PRESET_ALREADY.mapAndSend(player, str -> str.replace("%region%", args[2]).replace("%preset%", args[3]));
                            return false;
                        }
                        if (region.isAll() && region.getPresets().isEmpty()) {
                            region.setAll(false);
                        }
                        region.addPreset(preset.getName());
                        Message.PRESET_ADDED.mapAndSend(player, str -> str.replace("%preset%", args[3]).replace("%region%", args[2]));
                        break block14;
                    }
                    case "remove": {
                        if (args.length > 4) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region remove <name> <preset>", label)));
                            return false;
                        }
                        if (args.length < 4) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region remove <name> <preset>", label)));
                            return false;
                        }
                        RegenerationArea region = this.plugin.getRegionManager().getArea(args[2]);
                        if (region == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        BlockPreset preset = this.plugin.getPresetManager().getPreset(args[3]);
                        if (preset == null) {
                            Message.INVALID_PRESET.mapAndSend(player, str -> str.replace("%preset%", args[3]));
                            return false;
                        }
                        if (!region.hasPreset(preset.getName())) {
                            Message.DOES_NOT_HAVE_PRESET.mapAndSend(player, str -> str.replace("%region%", args[2]).replace("%preset%", args[3]));
                            return false;
                        }
                        if (region.isAll() && region.getPresets().isEmpty()) {
                            region.setAll(false);
                            this.plugin.getPresetManager().getPresets().values().forEach(p -> region.addPreset(p.getName()));
                        }
                        region.removePreset(preset.getName());
                        Message.PRESET_REMOVED.mapAndSend(player, str -> str.replace("%preset%", args[3]).replace("%region%", args[2]));
                        break block14;
                    }
                    case "clear": {
                        if (args.length > 3) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region clear <name>", label)));
                            return false;
                        }
                        if (args.length < 3) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region clear <name>", label)));
                            return false;
                        }
                        RegenerationArea region = this.plugin.getRegionManager().getArea(args[2]);
                        if (region == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        region.clearPresets();
                        Message.PRESETS_CLEARED.mapAndSend(player, str -> str.replace("%region%", region.getName()));
                        break block14;
                    }
                    case "copy": {
                        if (args.length > 4) {
                            Message.TOO_MANY_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region copy <region-from> <region-to>", label)));
                            return false;
                        }
                        if (args.length < 4) {
                            Message.NOT_ENOUGH_ARGS.mapAndSend(player, str -> str.replace("%help%", String.format("/%s region copy <region-from> <region-to>", label)));
                            return false;
                        }
                        RegenerationArea regionFrom = this.plugin.getRegionManager().getArea(args[2]);
                        if (regionFrom == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        RegenerationArea regionTo = this.plugin.getRegionManager().getArea(args[3]);
                        if (regionTo == null) {
                            Message.UNKNOWN_REGION.send(player);
                            return false;
                        }
                        regionTo.setAll(regionFrom.isAll());
                        regionTo.clearPresets();
                        regionFrom.getPresets().forEach(regionTo::addPreset);
                        Message.PRESETS_COPIED.mapAndSend(player, str -> str.replace("%regionFrom%", regionFrom.getName()).replace("%regionTo%", regionTo.getName()));
                        break block14;
                    }
                }
                this.sendHelp(sender, label);
                break;
            }
            case "regen": {
                if (!sender.hasPermission("blockregen.regen")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                String[] workArgs = Arrays.copyOfRange(args, 1, args.length);
                BlockPreset preset = null;
                String worldName = null;
                RegenerationArea region = null;
                Iterator it = Arrays.stream(workArgs).iterator();
                while (it.hasNext()) {
                    String arg = (String)it.next();
                    if (arg.equalsIgnoreCase("-p") && it.hasNext()) {
                        preset = this.plugin.getPresetManager().getPreset((String)it.next());
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-r") && it.hasNext()) {
                        region = this.plugin.getRegionManager().getArea((String)it.next());
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-w") && it.hasNext()) {
                        worldName = (String)it.next();
                        continue;
                    }
                    Message.UNKNOWN_ARGUMENT.send(sender);
                    return false;
                }
                HashSet<RegenerationProcess> toRegen = new HashSet<RegenerationProcess>();
                for (RegenerationProcess process : this.plugin.getRegenerationManager().getCache()) {
                    if (preset != null && !preset.equals(process.getPreset()) || region != null && !region.getName().equalsIgnoreCase(process.getRegionName()) || worldName != null && !worldName.equalsIgnoreCase(process.getWorldName())) continue;
                    toRegen.add(process);
                }
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> toRegen.forEach(RegenerationProcess::regenerate));
                Message.REGENERATED_PROCESSES.mapAndSend(sender, str -> str.replace("%count%", String.valueOf(toRegen.size())));
                break;
            }
            case "stats": {
                if (!sender.hasPermission("blockregen.admin")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                StringBuilder stats = new StringBuilder("&8&m        &r &3BlockRegen processes &8&m        &r\n");
                Collection<RegenerationProcess> processes = this.plugin.getRegenerationManager().getCache();
                if (processes.isEmpty()) {
                    stats.append("&7None to show.");
                    sender.sendMessage(Colors.color(stats.toString()));
                    break;
                }
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    Map<String, List<RegenerationProcess>> byWorldCollect = processes.stream().collect(Collectors.groupingBy(RegenerationProcess::getWorldName));
                    for (Map.Entry<String, List<RegenerationProcess>> byWorld : byWorldCollect.entrySet()) {
                        int byWorldCount = byWorld.getValue().size();
                        stats.append("&f").append(byWorld.getKey()).append(" &7(&f").append(byWorldCount).append("&7)&8:&7\n");
                        Map<String, List<RegenerationProcess>> byRegionCollect = processes.stream().collect(Collectors.groupingBy(RegenerationProcess::getRegionName));
                        for (Map.Entry<String, List<RegenerationProcess>> byRegion : byRegionCollect.entrySet()) {
                            int byRegionCount = byRegion.getValue().size();
                            stats.append(" &f").append(byRegion.getKey()).append(" &7(&f").append(byRegionCount).append("&7)&8:&7 ");
                            Map<String, List<RegenerationProcess>> byPresetCollect = processes.stream().collect(Collectors.groupingBy(RegenerationProcess::getPresetName));
                            for (Map.Entry<String, List<RegenerationProcess>> byPreset : byPresetCollect.entrySet()) {
                                int byPresetCount = byPreset.getValue().size();
                                stats.append("&f").append(byPreset.getKey()).append(" &7(&f").append(byPresetCount).append("&7) ");
                            }
                            stats.append("\n");
                        }
                    }
                    sender.sendMessage(Colors.color(stats.toString()));
                });
                break;
            }
            case "debug": {
                if (!sender.hasPermission("blockregen.debug")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                if (!(sender instanceof Player)) {
                    Message.ONLY_PLAYERS.send(sender);
                    return false;
                }
                Player player = (Player)sender;
                if (this.plugin.getConsoleHandler().getListeners().contains(sender)) {
                    if (!this.plugin.getFiles().getSettings().getFileConfiguration().getBoolean("Debug-Enabled", false) && this.plugin.getLogLevel().intValue() <= Level.FINE.intValue()) {
                        this.plugin.setLogLevel(Level.INFO);
                    }
                    this.plugin.getConsoleHandler().removeListener(sender);
                    Message.DEBUG_OFF.send(player);
                    break;
                }
                if (this.plugin.getLogLevel().intValue() > Level.FINE.intValue()) {
                    this.plugin.setLogLevel(Level.FINE);
                }
                this.plugin.getConsoleHandler().addListener(sender);
                Message.DEBUG_ON.send(player);
                break;
            }
            case "discord": {
                if (!sender.hasPermission("blockregen.admin")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                sender.sendMessage(Colors.color("&8&m        &r &3BlockRegen &f%version% &8&m        &r\n&7If you need help, either read through the wiki page or reach out on discord!&r\n\n&3Discord &7https://discord.gg/ZCxMca5&r\n&6Wiki &7https://github.com/Wertik/BlockRegen/wiki&r\n").replaceAll("(?i)%version%", this.plugin.getDescription().getVersion()));
                break;
            }
            case "events": {
                if (!sender.hasPermission("blockregen.events")) {
                    Message.NO_PERM.send(sender);
                    return false;
                }
                if (args.length < 3) {
                    if (this.plugin.getEventManager().getLoadedEvents().isEmpty()) {
                        sender.sendMessage(Colors.color("&8&m     &r &3BlockRegen Events &8&m     \n&cYou haven't made any events yet.\n&8&m                       "));
                        return false;
                    }
                    StringBuilder list = new StringBuilder("&8&m     &r &3BlockRegen Events &8&m     \n&7You have the following events loaded:").append("\n&r ");
                    for (PresetEvent event : this.plugin.getEventManager().getEvents(e -> true)) {
                        list.append("\n&8 - &r").append(event.getDisplayName()).append(" &7(Name: &f").append(event.getName()).append("&7) ").append(event.isEnabled() ? " &a(active)&r" : " &c(inactive)&r");
                    }
                    list.append("\n&r \n&7Use &3/").append(label).append(" events activate <name> &7to activate it.\n").append("&7Use &3/").append(label).append(" events deactivate <name> &7to de-activate it.");
                    sender.sendMessage(Colors.color(list.toString()));
                    break;
                }
                if (args[1].equalsIgnoreCase("activate")) {
                    String name = args[2];
                    PresetEvent event = this.plugin.getEventManager().getEvent(name);
                    if (event == null) {
                        Message.EVENT_NOT_FOUND.send(sender);
                        return false;
                    }
                    if (event.isEnabled()) {
                        Message.EVENT_ALREADY_ACTIVE.send(sender);
                        return false;
                    }
                    this.plugin.getEventManager().enableEvent(event);
                    Message.ACTIVATE_EVENT.mapAndSend(sender, str -> str.replace("%event%", event.getDisplayName()));
                    return false;
                }
                if (!args[1].equalsIgnoreCase("deactivate")) break;
                String name = args[2];
                PresetEvent event = this.plugin.getEventManager().getEvent(name);
                if (event == null) {
                    Message.EVENT_NOT_FOUND.send(sender);
                    return false;
                }
                if (!event.isEnabled()) {
                    Message.EVENT_NOT_ACTIVE.send(sender);
                    return false;
                }
                this.plugin.getEventManager().disableEvent(event);
                Message.DEACTIVATE_EVENT.mapAndSend(sender, str -> str.replace("%event%", event.getDisplayName()));
                return false;
            }
            default: {
                this.sendHelp(sender, label);
            }
        }
        return false;
    }

    private void giveTools(@NotNull Player player) {
        ItemStack shovel = XMaterial.WOODEN_SHOVEL.parseItem();
        ItemMeta meta = shovel.getItemMeta();
        meta.setDisplayName(Colors.color("&3BlockRegen preset tool"));
        meta.setLore((List)Lists.newArrayList((Object[])Colors.color("&fLeft click &7on a block in a region to add the blocks preset.", "&fRight click &7on a block in a region to remove the blocks preset.")));
        shovel.setItemMeta(meta);
        ItemStack axe = XMaterial.WOODEN_AXE.parseItem();
        meta = axe.getItemMeta();
        meta.setDisplayName(Colors.color("&3BlockRegen selection tool"));
        meta.setLore((List)Lists.newArrayList((Object[])Colors.color("&fLeft click &7to select first position.", "&fRight click &7to select second position.", "&f/blockregen region set <name> &7to create a region from selection.")));
        axe.setItemMeta(meta);
        player.getInventory().addItem(new ItemStack[]{shovel, axe});
        Message.TOOLS.send(player);
    }

    private void listRegions(CommandSender sender) {
        StringBuilder message = new StringBuilder("&8&m    &3 BlockRegen Regions &8&m    &r\n");
        for (RegenerationArea area : this.plugin.getRegionManager().getLoadedAreas()) {
            message.append(String.format(" &f%s\n", area.getName()));
            if (area instanceof RegenerationRegion) {
                RegenerationRegion region = (RegenerationRegion)area;
                message.append(String.format("  &7Area: &f%s &8- &f%s", Locations.locationToString(region.getMin()), Locations.locationToString(region.getMax()))).append('\n');
            } else if (area instanceof RegenerationWorld) {
                RegenerationWorld world = (RegenerationWorld)area;
                message.append("  &7World: &f").append(world.getWorldName()).append('\n');
            }
            message.append(String.format("  &7Priority: &f%d\n", area.getPriority()));
            if (area.isAll()) {
                message.append("  &7Presets: &aall\n");
                continue;
            }
            if (!area.getPresets().isEmpty()) {
                message.append("  &7Presets: ").append(String.format("&f%s\n", area.getPresets()));
                continue;
            }
            message.append("  &7Presets: &cnone\n");
        }
        sender.sendMessage(Colors.color(message.toString()));
    }

    private boolean checkConsole(CommandSender sender) {
        if (!(sender instanceof Player)) {
            Message.ONLY_PLAYERS.send(sender);
            return true;
        }
        return false;
    }
}

