/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.compatibility.CompatibilityProvider;
import nl.aurorion.blockregen.compatibility.ProviderContainer;
import nl.aurorion.blockregen.compatibility.impl.EconomyProvider;
import nl.aurorion.blockregen.compatibility.impl.GriefPreventionProvider;
import nl.aurorion.blockregen.compatibility.impl.ItemsAdderProvider;
import nl.aurorion.blockregen.compatibility.impl.JobsProvider;
import nl.aurorion.blockregen.compatibility.impl.MMOItemsProvider;
import nl.aurorion.blockregen.compatibility.impl.NexoProvider;
import nl.aurorion.blockregen.compatibility.impl.OraxenProvider;
import nl.aurorion.blockregen.compatibility.impl.ResidenceProvider;
import nl.aurorion.blockregen.drop.ItemProvider;
import nl.aurorion.blockregen.material.parser.MaterialParser;

public class CompatibilityManager {
    @Generated
    private static final Logger log = Logger.getLogger(CompatibilityManager.class.getName());
    private final BlockRegenPlugin plugin;
    private final List<ProviderContainer<?>> containers = new ArrayList();
    private final ProviderContainer<JobsProvider> jobs;
    private final ProviderContainer<OraxenProvider> oraxen;
    private final ProviderContainer<ItemsAdderProvider> itemsAdder;
    private final ProviderContainer<NexoProvider> nexo;
    private final ProviderContainer<MMOItemsProvider> mmoItems;
    private final ProviderContainer<GriefPreventionProvider> griefPrevention;
    private final ProviderContainer<ResidenceProvider> residence;
    private final ProviderContainer<EconomyProvider> economy;

    public CompatibilityManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
        this.jobs = this.createProvider("Jobs", () -> new JobsProvider(plugin)).requiresReloadAfterFound(true);
        this.oraxen = this.createProvider("Oraxen", () -> new OraxenProvider(plugin));
        this.itemsAdder = this.createProvider("ItemsAdder", () -> new ItemsAdderProvider(plugin));
        this.nexo = this.createProvider("Nexo", () -> new NexoProvider(plugin));
        this.mmoItems = this.createProvider("MMOItems", () -> new MMOItemsProvider(plugin));
        this.griefPrevention = this.createProvider("GriefPrevention", () -> new GriefPreventionProvider(plugin));
        this.residence = this.createProvider("Residence", () -> new ResidenceProvider(plugin));
        this.economy = this.createProvider("Vault", () -> new EconomyProvider(plugin));
    }

    private <T extends CompatibilityProvider> ProviderContainer<T> createProvider(String pluginName, Supplier<T> supplier) {
        ProviderContainer<T> container = new ProviderContainer<T>(this.plugin, pluginName, supplier);
        this.containers.add(container);
        return container;
    }

    public void discover(boolean shouldReloadPresets) {
        boolean reloadPresets = false;
        for (ProviderContainer<?> container : this.containers) {
            Object provider;
            if (container.isFound() || !container.isPluginEnabled()) continue;
            container.setFound(true);
            try {
                container.load();
            }
            catch (IllegalStateException e) {
                log.warning("Failed to load support for " + container.getPluginName() + ": " + e.getMessage());
                continue;
            }
            if (container.requiresReloadAfterFound()) {
                reloadPresets = true;
            }
            if ((provider = container.get()) instanceof MaterialParser && ((CompatibilityProvider)provider).getPrefix() != null) {
                this.plugin.getMaterialManager().registerParser(((CompatibilityProvider)provider).getPrefix(), (MaterialParser)provider);
                reloadPresets = true;
            }
            if (provider instanceof ItemProvider && ((CompatibilityProvider)provider).getPrefix() != null) {
                this.plugin.getItemManager().registerProvider(((CompatibilityProvider)provider).getPrefix(), (ItemProvider)provider);
                reloadPresets = true;
            }
            log.info("Loaded support for " + container.getPluginName() + "!" + (((CompatibilityProvider)provider).getFeatures() == null ? "" : " Features: &a" + String.join((CharSequence)"&7, &a", ((CompatibilityProvider)provider).getFeatures()) + "&7."));
        }
        if (reloadPresets && shouldReloadPresets) {
            log.info("Reloading presets due to newly discovered supported plugins...");
            this.plugin.getPresetManager().load();
        }
    }

    @Generated
    public ProviderContainer<JobsProvider> getJobs() {
        return this.jobs;
    }

    @Generated
    public ProviderContainer<OraxenProvider> getOraxen() {
        return this.oraxen;
    }

    @Generated
    public ProviderContainer<ItemsAdderProvider> getItemsAdder() {
        return this.itemsAdder;
    }

    @Generated
    public ProviderContainer<NexoProvider> getNexo() {
        return this.nexo;
    }

    @Generated
    public ProviderContainer<MMOItemsProvider> getMmoItems() {
        return this.mmoItems;
    }

    @Generated
    public ProviderContainer<GriefPreventionProvider> getGriefPrevention() {
        return this.griefPrevention;
    }

    @Generated
    public ProviderContainer<ResidenceProvider> getResidence() {
        return this.residence;
    }

    @Generated
    public ProviderContainer<EconomyProvider> getEconomy() {
        return this.economy;
    }
}

