/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.conditional;

import java.util.List;
import nl.aurorion.blockregen.conditional.ComposedCondition;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.conditional.ConditionFunction;
import nl.aurorion.blockregen.conditional.ConditionRelation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Condition {
    private String alias = null;
    private boolean negate = false;

    protected Condition() {
    }

    protected Condition(String alias) {
        this.alias = alias;
    }

    @NotNull
    public static Condition of(final @NotNull ConditionFunction function) {
        return new Condition(){

            @Override
            public boolean match(ConditionContext context) {
                return function.match(context);
            }
        };
    }

    @NotNull
    public static Condition of(final @NotNull ConditionFunction function, String alias) {
        return new Condition(alias){

            @Override
            public boolean match(ConditionContext context) {
                return function.match(context);
            }
        };
    }

    public static Condition truthy() {
        return Condition.constant(true, "true");
    }

    public static Condition falsy() {
        return Condition.constant(false, "false");
    }

    public static Condition constant(boolean value, String alias) {
        return Condition.of(ctx -> value, alias);
    }

    public static Condition constant(boolean value) {
        return Condition.of(ctx -> value, "C");
    }

    public static Condition anyOf(List<Condition> conditions) {
        return new ComposedCondition(ConditionRelation.OR, conditions);
    }

    public static Condition allOf(List<Condition> conditions) {
        return new ComposedCondition(ConditionRelation.AND, conditions);
    }

    public abstract boolean match(ConditionContext var1);

    public boolean matches(ConditionContext context) {
        return this.negate ^ this.match(context);
    }

    public Condition and(Condition condition) {
        ComposedCondition composed;
        if (this instanceof ComposedCondition && (composed = (ComposedCondition)this).getRelation() == ConditionRelation.AND) {
            composed.append(condition);
            return this;
        }
        return new ComposedCondition(ConditionRelation.AND, this, condition);
    }

    public Condition or(Condition condition) {
        ComposedCondition composed;
        if (this instanceof ComposedCondition && (composed = (ComposedCondition)this).getRelation() == ConditionRelation.OR) {
            composed.append(condition);
            return this;
        }
        return new ComposedCondition(ConditionRelation.OR, this, condition);
    }

    public Condition negate() {
        this.negate = !this.negate;
        return this;
    }

    public String toString() {
        return this.alias();
    }

    @Nullable
    public String getAlias() {
        return this.alias;
    }

    @NotNull
    public String alias() {
        String a = this.alias == null ? "X" : this.alias;
        return this.negate ? "!" + a : a;
    }

    @NotNull
    public Condition alias(String alias) {
        this.alias = alias;
        return this;
    }

    static class Aliases {
        public static final String DEFAULT_VARIABLE = "X";
        public static final String DEFAULT_CONSTANT = "C";
        public static final String TRUE = "true";
        public static final String FALSE = "false";

        Aliases() {
        }
    }
}

