/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.event.struct.PresetEvent;
import org.bukkit.Bukkit;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventManager {
    @Generated
    private static final Logger log = Logger.getLogger(EventManager.class.getName());
    private final BlockRegenPlugin plugin;
    private final Map<String, PresetEvent> loadedEvents = new HashMap<String, PresetEvent>();

    public EventManager(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    public void clearBars() {
        for (PresetEvent event : this.getEvents(e -> e.isEnabled() && e.getActiveBossBar() != null)) {
            event.getActiveBossBar().removeAll();
        }
    }

    public void removeBars(Player player) {
        if (this.plugin.getVersionManager().isCurrentBelow("1.8", true)) {
            return;
        }
        for (PresetEvent event : this.getEvents(e -> e.isEnabled() && e.getActiveBossBar() != null)) {
            event.getActiveBossBar().addPlayer(player);
        }
    }

    public void addBars(Player player) {
        if (this.plugin.getVersionManager().isCurrentBelow("1.8", true)) {
            return;
        }
        for (PresetEvent event : this.getEvents(e -> e.isEnabled() && e.getActiveBossBar() != null)) {
            event.getActiveBossBar().addPlayer(player);
        }
    }

    public void disableEvent(PresetEvent event) {
        if (!event.isEnabled()) {
            return;
        }
        event.setEnabled(false);
        log.fine(() -> "Disabled event " + event.getName());
        if (this.plugin.getVersionManager().isCurrentBelow("1.8", true)) {
            return;
        }
        BossBar bossBar = event.getActiveBossBar();
        if (bossBar == null) {
            return;
        }
        bossBar.removeAll();
    }

    public void disableEvent(String name) {
        PresetEvent event = this.loadedEvents.get(name);
        if (event != null) {
            this.disableEvent(event);
        }
    }

    public void disableAll() {
        this.getEvents(PresetEvent::isEnabled).forEach(this::disableEvent);
    }

    public void enableEvent(@NotNull PresetEvent event) {
        if (event.isEnabled()) {
            return;
        }
        event.setEnabled(true);
        log.fine(() -> "Enabled event " + event.getName());
        if (this.plugin.getVersionManager().isCurrentBelow("1.8", true) || event.getBossBar() == null) {
            return;
        }
        BossBar bossBar = this.plugin.getVersionManager().getMethods().createBossBar(event.getBossBar().getText(), event.getBossBar().getColor(), event.getBossBar().getStyle());
        if (bossBar == null) {
            return;
        }
        event.setActiveBossBar(bossBar);
        Bukkit.getOnlinePlayers().forEach(arg_0 -> ((BossBar)bossBar).addPlayer(arg_0));
    }

    public void enableEvent(String name) {
        PresetEvent event = this.loadedEvents.get(name);
        if (event != null) {
            this.enableEvent(event);
        }
    }

    public void addEvent(PresetEvent event) {
        this.loadedEvents.put(event.getName(), event);
        log.fine(() -> "Added event " + event);
    }

    public boolean isEnabled(String name) {
        return this.loadedEvents.containsKey(name) && this.loadedEvents.get(name).isEnabled();
    }

    @Nullable
    public PresetEvent getEvent(String name) {
        return this.loadedEvents.get(name);
    }

    public void clearEvents() {
        this.loadedEvents.clear();
    }

    public Set<PresetEvent> getEvents(Predicate<PresetEvent> predicate) {
        return this.getLoadedEvents().values().stream().filter(predicate).collect(Collectors.toSet());
    }

    public Map<String, PresetEvent> getLoadedEvents() {
        return Collections.unmodifiableMap(this.loadedEvents);
    }
}

