/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.event.struct;

import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventBossBar {
    @Generated
    private static final Logger log = Logger.getLogger(EventBossBar.class.getName());
    private String text;
    private String color;
    private String style;

    @Nullable
    public static EventBossBar load(@Nullable ConfigurationSection section, @NotNull String defaultText) {
        if (section == null) {
            return null;
        }
        EventBossBar bossBar = new EventBossBar();
        bossBar.setText(section.getString("name", defaultText));
        String barStyle = section.getString("style", "SOLID");
        if (!BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().isBarStyleValid(barStyle)) {
            log.warning("Boss bar style " + barStyle + " is invalid, using SOLID as default.");
            bossBar.setStyle("SOLID");
        } else {
            bossBar.setStyle(barStyle);
        }
        String barColor = section.getString("color", "BLUE");
        if (!BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().isBarColorValid(barColor)) {
            log.warning("Boss bar color " + barColor + " is invalid, using BLUE as default.");
            bossBar.setColor("BLUE");
        } else {
            bossBar.setColor(barColor);
        }
        return bossBar;
    }

    @Generated
    public EventBossBar() {
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public String getStyle() {
        return this.style;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setStyle(String style) {
        this.style = style;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventBossBar)) {
            return false;
        }
        EventBossBar other = (EventBossBar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !this$style.equals(other$style));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventBossBar;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventBossBar(text=" + this.getText() + ", color=" + this.getColor() + ", style=" + this.getStyle() + ")";
    }
}

