/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.material;

import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.mechanics.Mechanic;
import com.nexomc.nexo.mechanics.custom_block.noteblock.NoteBlockMechanic;
import java.util.Objects;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NexoMaterial
implements BlockRegenMaterial {
    private final BlockRegenPlugin plugin;
    private final String itemId;

    public NexoMaterial(BlockRegenPlugin plugin, String itemId) {
        this.plugin = plugin;
        this.itemId = itemId;
    }

    @Nullable
    public static Mechanic getNexoBlock(@NotNull Block block) {
        NoteBlockMechanic mechanic;
        if (!NexoBlocks.isCustomBlock((Block)block)) {
            mechanic = null;
        } else {
            switch (block.getType()) {
                case NOTE_BLOCK: {
                    mechanic = NexoBlocks.noteBlockMechanic((Block)block);
                    break;
                }
                case TRIPWIRE: {
                    mechanic = NexoBlocks.stringMechanic((Block)block);
                    break;
                }
                default: {
                    mechanic = NexoBlocks.customBlockMechanic((BlockData)block.getBlockData());
                }
            }
        }
        return mechanic;
    }

    @Override
    public boolean check(Block block) {
        Mechanic mechanic = NexoMaterial.getNexoBlock(block);
        if (mechanic == null) {
            return false;
        }
        return Objects.equals(mechanic.getItemID(), this.itemId);
    }

    @Override
    public void setType(Block block) {
        NexoBlocks.place((String)this.itemId, (Location)block.getLocation());
    }

    public String toString() {
        return "NexoMaterial{itemId='" + this.itemId + '\'' + '}';
    }

    @Generated
    public String getItemId() {
        return this.itemId;
    }
}

