/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.preset.FixedNumberValue;
import nl.aurorion.blockregen.preset.UniformNumberValue;
import nl.aurorion.blockregen.util.Parsing;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface NumberValue {
    public double getDouble();

    public int getInt();

    @NotNull
    public static UniformNumberValue uniform(double low, double high) {
        return new UniformNumberValue(Math.min(low, high), Math.max(low, high));
    }

    @NotNull
    public static FixedNumberValue fixed(double value) {
        return new FixedNumberValue(value);
    }

    public static class Parser {
        @Generated
        private static final Logger log = Logger.getLogger(Parser.class.getName());
        private static final Pattern DASH_PATTERN = Pattern.compile("(-?\\d+)-(-?\\d+)");

        @NotNull
        @Contract(value="null->fail")
        public static NumberValue parse(String input) {
            if (Strings.isNullOrEmpty((String)input)) {
                throw new ParseException("No input supplied.");
            }
            Matcher matcher = DASH_PATTERN.matcher(input);
            log.finer(() -> "Input: " + input);
            if (matcher.matches()) {
                double low = Parsing.parseDouble(matcher.group(1), "Invalid value for low supplied: '" + matcher.group(1) + "'.");
                double high = Parsing.parseDouble(matcher.group(2), "Invalid value for high supplied: '" + matcher.group(1) + "'.");
                return NumberValue.uniform(low, high);
            }
            return FixedNumberValue.parse(input);
        }

        @NotNull
        public static NumberValue load(@NotNull Object node) {
            Objects.requireNonNull(node);
            if (node instanceof ConfigurationSection) {
                ConfigurationSection section = (ConfigurationSection)node;
                if (!(section.get("low") instanceof Number) || !(section.get("high") instanceof Number)) {
                    throw new ParseException("Invalid properties for values.");
                }
                double low = section.getDouble("low");
                double high = section.getDouble("high");
                return NumberValue.uniform(low, high);
            }
            return Parser.parse(String.valueOf(node));
        }
    }
}

