/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobsPlayer;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.Message;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.util.Text;
import nl.aurorion.blockregen.xseries.XEnchantment;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class PresetConditions {
    @Generated
    private static final Logger log = Logger.getLogger(PresetConditions.class.getName());
    private final List<XMaterial> toolsRequired = new ArrayList<XMaterial>();
    private final Map<XEnchantment, Integer> enchantsRequired = new HashMap<XEnchantment, Integer>();
    private final Map<Job, Integer> jobsRequired = new HashMap<Job, Integer>();

    public boolean check(Player player) {
        return this.checkTools(player) && this.checkEnchants(player) && this.checkJobs(player);
    }

    public boolean checkTools(Player player) {
        if (this.toolsRequired.isEmpty()) {
            return true;
        }
        ItemStack tool = BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().getItemInMainHand(player);
        if (this.toolsRequired.contains(XMaterial.matchXMaterial(tool))) {
            return true;
        }
        String requirements = this.composeToolRequirements();
        Message.TOOL_REQUIRED_ERROR.mapAndSend(player, str -> str.replace("%tool%", requirements));
        log.fine(() -> String.format("Player doesn't have the required tools. Tool: %s, required: %s", tool.getType(), requirements));
        return false;
    }

    private String composeToolRequirements() {
        return this.toolsRequired.stream().map(xMaterial -> Text.capitalize(xMaterial.toString().toLowerCase().replace("_", " "))).collect(Collectors.joining(", "));
    }

    public boolean checkEnchants(Player player) {
        if (this.enchantsRequired.isEmpty()) {
            return true;
        }
        ItemStack tool = BlockRegenPluginImpl.getInstance().getVersionManager().getMethods().getItemInMainHand(player);
        ItemMeta meta = tool.getItemMeta();
        String requirements = this.compressEnchantRequirements();
        String enchants = "None";
        if (meta != null && tool.getType() != Material.AIR) {
            enchants = meta.getEnchants().toString();
            for (Map.Entry<XEnchantment, Integer> entry : this.enchantsRequired.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey().get();
                if (enchantment == null || !meta.hasEnchant(enchantment) || meta.getEnchantLevel(enchantment) < entry.getValue()) continue;
                return true;
            }
        }
        Message.ENCHANT_REQUIRED_ERROR.mapAndSend(player, str -> str.replace("%enchant%", requirements));
        log.fine(String.format("Player doesn't have the required enchants. Enchants: %s, required: %s", enchants, requirements));
        return false;
    }

    private String compressEnchantRequirements() {
        return this.enchantsRequired.entrySet().stream().map(e -> String.format("%s (%d)", Text.capitalize(((XEnchantment)e.getKey()).name().toLowerCase().replace("_", " ")), e.getValue())).collect(Collectors.joining(", "));
    }

    public boolean checkJobs(Player player) {
        if (BlockRegenPluginImpl.getInstance().getCompatibilityManager().getJobs().isLoaded() || this.jobsRequired.isEmpty()) {
            return true;
        }
        JobsPlayer jobsPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        for (Map.Entry<Job, Integer> entry : this.jobsRequired.entrySet()) {
            if (!Jobs.getPlayerManager().getJobsPlayer(player).isInJob(entry.getKey()) || jobsPlayer.getJobProgression(entry.getKey()).getLevel() < entry.getValue()) continue;
            return true;
        }
        String requirements = this.compressJobRequirements();
        Message.JOBS_REQUIRED_ERROR.mapAndSend(player, str -> str.replace("%job%", requirements));
        log.fine(() -> String.format("Player doesn't have the required jobs. Jobs: %s, required: %s", jobsPlayer.getJobProgression().stream().map(Object::toString).collect(Collectors.joining(", ")), requirements));
        return false;
    }

    private String compressJobRequirements() {
        return this.jobsRequired.entrySet().stream().map(e -> String.format("%s (%d)", ((Job)e.getKey()).getName(), e.getValue())).collect(Collectors.joining(", "));
    }

    public void setToolsRequired(@NotNull String input) {
        String[] arr = input.split(", ");
        this.toolsRequired.clear();
        for (String loop : arr) {
            XMaterial material = Parsing.parseMaterial(loop);
            this.toolsRequired.add(material);
        }
    }

    public void setEnchantsRequired(@NotNull String input) {
        String[] arr = input.split(", ");
        this.enchantsRequired.clear();
        for (String loop : arr) {
            String enchantmentName = loop.split(";")[0];
            XEnchantment enchantment = Parsing.parseEnchantment(enchantmentName);
            int level = 1;
            if (loop.contains(";") && (level = Integer.parseInt(loop.split(";")[1])) < 0) {
                log.warning("Could not parse an enchantment level in " + input);
                continue;
            }
            this.enchantsRequired.put(enchantment, level);
        }
    }

    public void setJobsRequired(@Nullable String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return;
        }
        String[] arr = input.split(", ");
        this.jobsRequired.clear();
        for (String loop : arr) {
            Job job;
            int level = 1;
            if (loop.contains(";")) {
                job = Jobs.getJob((String)loop.split(";")[0]);
                level = Integer.parseInt(loop.split(";")[1]);
            } else {
                job = Jobs.getJob((String)loop);
            }
            this.jobsRequired.put(job, level);
        }
    }

    public String toString() {
        return "PresetConditions{toolsRequired=" + this.toolsRequired + ", enchantsRequired=" + this.enchantsRequired + ", jobsRequired=" + this.jobsRequired + '}';
    }

    @Generated
    public PresetConditions() {
    }
}

