/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.preset.Command;
import nl.aurorion.blockregen.preset.NumberValue;
import nl.aurorion.blockregen.preset.drop.DropItem;
import nl.aurorion.blockregen.util.Text;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PresetRewards {
    @Generated
    private static final Logger log = Logger.getLogger(PresetRewards.class.getName());
    private NumberValue money;
    private List<Command> consoleCommands;
    private List<Command> playerCommands;
    private List<DropItem> drops = new ArrayList<DropItem>();

    public void give(Player player, Function<String, String> parser) {
        AtomicDouble money = new AtomicDouble(0.0);
        if (BlockRegenPluginImpl.getInstance().getCompatibilityManager().getEconomy().isLoaded()) {
            money.set(this.money.getDouble());
            double m = money.get();
            if (m > 0.0) {
                BlockRegenPluginImpl.getInstance().getCompatibilityManager().getEconomy().get().depositPlayer((OfflinePlayer)player, m);
            }
        }
        Function<String, String> finalParser = string -> Text.replace((String)parser.apply((String)string), "earned_money", money.get());
        Bukkit.getScheduler().runTask((Plugin)BlockRegenPluginImpl.getInstance(), () -> {
            for (Command command : this.playerCommands) {
                if (!command.shouldExecute()) continue;
                Bukkit.dispatchCommand((CommandSender)player, (String)((String)finalParser.apply(command.getCommand())));
            }
            for (Command command : this.consoleCommands) {
                if (!command.shouldExecute()) continue;
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)((String)finalParser.apply(command.getCommand())));
            }
        });
    }

    public void parseConsoleCommands(@NotNull List<String> consoleCommands) {
        this.consoleCommands = this.parseCommands(consoleCommands);
    }

    public void parsePlayerCommands(@NotNull List<String> playerCommands) {
        this.playerCommands = this.parseCommands(playerCommands);
    }

    private List<Command> parseCommands(@NotNull List<String> strCommands) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (String strCmd : strCommands) {
            if (strCmd.contains(";")) {
                double chance;
                String[] args = strCmd.split(" *; *");
                try {
                    chance = Double.parseDouble(args[0]);
                }
                catch (NumberFormatException e) {
                    log.warning(String.format("Invalid number format for input %s in command %s", args[0], strCmd));
                    continue;
                }
                if (args[1].trim().isEmpty()) continue;
                commands.add(new Command(args[1], chance));
                continue;
            }
            if (strCmd.trim().isEmpty()) continue;
            commands.add(new Command(strCmd, 100.0));
        }
        return commands;
    }

    public void setDrops(List<DropItem> drops) {
        this.drops = drops == null ? new ArrayList() : drops;
    }

    public String toString() {
        return "PresetRewards{money=" + this.money + ", consoleCommands=" + this.consoleCommands + ", playerCommands=" + this.playerCommands + ", drops=" + this.drops + '}';
    }

    @Generated
    public PresetRewards() {
    }

    @Generated
    public NumberValue getMoney() {
        return this.money;
    }

    @Generated
    public void setMoney(NumberValue money) {
        this.money = money;
    }

    @Generated
    public List<Command> getConsoleCommands() {
        return this.consoleCommands;
    }

    @Generated
    public List<Command> getPlayerCommands() {
        return this.playerCommands;
    }

    @Generated
    public List<DropItem> getDrops() {
        return this.drops;
    }
}

