/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.Pair;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.conditional.Condition;
import nl.aurorion.blockregen.conditional.ConditionContext;
import nl.aurorion.blockregen.preset.FixedNumberValue;
import nl.aurorion.blockregen.preset.condition.ConditionProvider;
import nl.aurorion.blockregen.preset.condition.ConditionRelation;
import nl.aurorion.blockregen.preset.condition.GenericConditionProvider;
import nl.aurorion.blockregen.preset.condition.expression.Expression;
import nl.aurorion.blockregen.preset.condition.expression.Operand;
import nl.aurorion.blockregen.util.Parsing;
import nl.aurorion.blockregen.xseries.XEnchantment;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DefaultConditions {
    @Generated
    private static final Logger log = Logger.getLogger(DefaultConditions.class.getName());

    @NotNull
    public static Pair<String, GenericConditionProvider.ProviderEntry> tool() {
        return new Pair<String, GenericConditionProvider.ProviderEntry>("tool", GenericConditionProvider.ProviderEntry.of((ConditionProvider)GenericConditionProvider.empty().addProvider("material", GenericConditionProvider.ProviderEntry.of((key, node) -> {
            XMaterial xMaterial = Parsing.parseMaterial((String)node);
            return Condition.of(ctx -> ctx.mustVar("material") == xMaterial).alias("material == " + xMaterial);
        }, String.class)).addProvider("enchants", GenericConditionProvider.ProviderEntry.of((key, node) -> {
            String v = (String)node;
            Expression expression = Expression.withCustomOperands(str -> DefaultConditions.getEnchantmentLevel(Parsing.parseEnchantment(str)), v);
            log.fine(() -> "Loaded enchants expression " + expression);
            return Condition.of(expression::evaluate).alias(v);
        }, ConditionRelation.AND)).extender(ctx -> {
            ItemStack item = (ItemStack)ctx.mustVar("tool");
            return ConditionContext.empty().with("material", XMaterial.matchXMaterial(item)).with("enchants", item.getEnchantments());
        }), ConditionRelation.AND));
    }

    @NotNull
    private static Operand getEnchantmentLevel(XEnchantment xEnchantment) {
        Operand op1 = ctx -> {
            Map enchants = (Map)ctx.mustVar("enchants");
            for (Map.Entry entry : enchants.entrySet()) {
                if (entry.getKey() != xEnchantment.get()) continue;
                return entry.getValue();
            }
            return 0;
        };
        return op1;
    }

    @NotNull
    public static Pair<String, GenericConditionProvider.ProviderEntry> placeholder() {
        return new Pair<String, GenericConditionProvider.ProviderEntry>("placeholder", GenericConditionProvider.ProviderEntry.of((key, node) -> {
            String input = (String)node;
            Expression expression = Expression.from(input);
            return Condition.of(expression::evaluate).alias(expression.pretty());
        }, String.class));
    }

    @NotNull
    public static Pair<String, GenericConditionProvider.ProviderEntry> chance() {
        return new Pair<String, GenericConditionProvider.ProviderEntry>("chance", GenericConditionProvider.ProviderEntry.of((key, node) -> {
            FixedNumberValue numberValue;
            try {
                numberValue = FixedNumberValue.from(node);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage());
            }
            Random random = new Random();
            return Condition.of(ctx -> random.nextDouble() < numberValue.getDouble() / 100.0).alias("chance (" + numberValue + "%)");
        }, Double.class, Integer.class, String.class));
    }

    @NotNull
    public static List<Pair<String, GenericConditionProvider.ProviderEntry>> all() {
        return Lists.newArrayList((Object[])new Pair[]{DefaultConditions.tool(), DefaultConditions.placeholder(), DefaultConditions.chance()});
    }
}

