/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.condition.expression;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.preset.condition.expression.Comparator;
import org.jetbrains.annotations.NotNull;

public class TypedComparisons {
    @Generated
    private static final Logger log = Logger.getLogger(TypedComparisons.class.getName());
    private final Map<Class<?>, Comparator<Object>> comparators = new HashMap();

    @NotNull
    static <T> TypedComparisons of(@NotNull Class<T> clazz, @NotNull Comparator<T> cmp) {
        TypedComparisons comparisons = new TypedComparisons();
        comparisons.add(clazz, cmp);
        return comparisons;
    }

    @NotNull
    <T> TypedComparisons add(@NotNull Class<T> clazz, @NotNull Comparator<T> cmp) {
        this.comparators.put(clazz, cmp);
        return this;
    }

    boolean parse(@NotNull Object o1, @NotNull Object o2) {
        for (Map.Entry<Class<?>, Comparator<Object>> entry : this.comparators.entrySet()) {
            Class<?> clazz = entry.getKey();
            Comparator<Object> cmp = entry.getValue();
            if (!clazz.isAssignableFrom(o1.getClass()) || !clazz.isAssignableFrom(o2.getClass())) continue;
            log.fine(() -> clazz + " " + o1 + " (" + o1.getClass() + ") " + o2 + " (" + o2.getClass() + ")");
            return (Boolean)cmp.apply(o1, o2);
        }
        throw new ParseException("Values " + o1 + " (" + o1.getClass().getSimpleName() + ") and " + o2 + " (" + o2.getClass().getSimpleName() + ") are not comparable.");
    }
}

