/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.drop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPluginImpl;
import nl.aurorion.blockregen.preset.drop.DropItem;
import nl.aurorion.blockregen.preset.drop.Enchant;
import nl.aurorion.blockregen.util.Colors;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;

public class MinecraftDropItem
extends DropItem {
    @Generated
    private static final Logger log = Logger.getLogger(MinecraftDropItem.class.getName());
    private final XMaterial material;
    private String displayName;
    private List<String> lore = new ArrayList<String>();
    private Set<Enchant> enchants = new HashSet<Enchant>();
    private Set<ItemFlag> itemFlags = new HashSet<ItemFlag>();
    private Integer customModelData;
    private NamespacedKey itemModel;

    public MinecraftDropItem(XMaterial material) {
        this.material = material;
    }

    @Override
    @Nullable
    public ItemStack toItemStack(Function<String, String> parser) {
        int amount = this.amount.getInt();
        if (amount <= 0) {
            return null;
        }
        ItemStack itemStack = this.material.parseItem();
        if (itemStack == null) {
            return null;
        }
        itemStack.setAmount(amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        if (this.displayName != null) {
            itemMeta.setDisplayName(Colors.color(parser.apply(this.displayName)));
        }
        if (this.lore != null) {
            ArrayList<String> lore = new ArrayList<String>(this.lore);
            lore.replaceAll(o -> Colors.color((String)parser.apply((String)o)));
            itemMeta.setLore(lore);
        }
        this.enchants.forEach(enchant -> enchant.apply(itemMeta));
        itemMeta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
        if (BlockRegenPluginImpl.getInstance().getVersionManager().useCustomModelData() && this.customModelData != null) {
            itemMeta.setCustomModelData(this.customModelData);
            log.fine(() -> String.format("Setting custom model data of %d", this.customModelData));
        }
        if (this.itemModel != null) {
            itemMeta.setItemModel(this.itemModel);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public String toString() {
        return "ItemDrop{material=" + this.material + ", amount=" + this.amount + ", displayName='" + this.displayName + '\'' + ", lore=" + this.lore + ", enchants=" + this.enchants + ", itemFlags=" + this.itemFlags + ", dropNaturally=" + this.dropNaturally + ", experienceDrop=" + this.experienceDrop + ", chance=" + this.chance + ", customModelData=" + this.customModelData + ", itemModel=" + this.itemModel + ", condition=" + this.condition + '}';
    }

    @Generated
    public XMaterial getMaterial() {
        return this.material;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public Set<Enchant> getEnchants() {
        return this.enchants;
    }

    @Generated
    public Set<ItemFlag> getItemFlags() {
        return this.itemFlags;
    }

    @Generated
    public Integer getCustomModelData() {
        return this.customModelData;
    }

    @Generated
    public NamespacedKey getItemModel() {
        return this.itemModel;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    @Generated
    public void setEnchants(Set<Enchant> enchants) {
        this.enchants = enchants;
    }

    @Generated
    public void setItemFlags(Set<ItemFlag> itemFlags) {
        this.itemFlags = itemFlags;
    }

    @Generated
    public void setCustomModelData(Integer customModelData) {
        this.customModelData = customModelData;
    }

    @Generated
    public void setItemModel(NamespacedKey itemModel) {
        this.itemModel = itemModel;
    }
}

