/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.preset.material;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.material.BlockRegenMaterial;
import nl.aurorion.blockregen.util.DiscreteGenerator;
import org.jetbrains.annotations.NotNull;

public class PlacementMaterial {
    @Generated
    private static final Logger log = Logger.getLogger(PlacementMaterial.class.getName());
    private final DiscreteGenerator<BlockRegenMaterial> generator;
    private final Map<BlockRegenMaterial, Double> valuedMaterials;

    private PlacementMaterial(Map<BlockRegenMaterial, Double> valuedMaterials) {
        this.valuedMaterials = valuedMaterials;
        this.generator = DiscreteGenerator.fromProbabilityFunction(valuedMaterials);
    }

    @NotNull
    public static PlacementMaterial withOnlyDefault(BlockRegenMaterial defaultMaterial) {
        HashMap<BlockRegenMaterial, Double> valued = new HashMap<BlockRegenMaterial, Double>();
        valued.put(defaultMaterial, 1.0);
        return new PlacementMaterial(valued);
    }

    @NotNull
    public static PlacementMaterial from(Map<BlockRegenMaterial, Double> valuedMaterials) {
        return new PlacementMaterial(valuedMaterials);
    }

    public Map<BlockRegenMaterial, Double> getValuedMaterials() {
        return Collections.unmodifiableMap(this.valuedMaterials);
    }

    @NotNull
    public BlockRegenMaterial get() {
        return this.generator.next();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<BlockRegenMaterial, Double> entry : this.valuedMaterials.entrySet()) {
            builder.append(String.format("%s: %.2f", entry.getKey(), entry.getValue())).append(",");
        }
        return "DynamicMaterial{valuedMaterials=" + builder.substring(0, builder.length() - 1) + '}';
    }
}

