/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.region.struct;

import java.util.List;
import lombok.Generated;
import nl.aurorion.blockregen.region.struct.RegenerationRegion;
import nl.aurorion.blockregen.util.Locations;
import org.bukkit.Location;

public class RawRegion {
    private final String name;
    private final String min;
    private final String max;
    private final List<String> blockPresets;
    private final boolean all;
    private final int priority;
    private boolean reattempt = false;

    public RawRegion(String name, String min, String max, List<String> blockPresets, boolean all, int priority) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.blockPresets = blockPresets;
        this.all = all;
        this.priority = priority;
    }

    public RegenerationRegion build() {
        Location min = Locations.locationFromString(this.min);
        Location max = Locations.locationFromString(this.max);
        if (min == null || max == null) {
            return null;
        }
        Location actualMin = new Location(min.getWorld(), Double.min(min.getX(), max.getX()), Double.min(min.getY(), max.getY()), Double.min(min.getZ(), max.getZ()));
        Location actualMax = new Location(min.getWorld(), Double.max(min.getX(), max.getX()), Double.max(min.getY(), max.getY()), Double.max(min.getZ(), max.getZ()));
        RegenerationRegion region = new RegenerationRegion(this.name, actualMin, actualMax);
        region.setPriority(this.priority);
        region.setAll(this.all);
        return region;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMin() {
        return this.min;
    }

    @Generated
    public String getMax() {
        return this.max;
    }

    @Generated
    public List<String> getBlockPresets() {
        return this.blockPresets;
    }

    @Generated
    public boolean isAll() {
        return this.all;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public boolean isReattempt() {
        return this.reattempt;
    }

    @Generated
    public void setReattempt(boolean reattempt) {
        this.reattempt = reattempt;
    }
}

