/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.region.struct;

import lombok.Generated;
import nl.aurorion.blockregen.region.struct.RegenerationArea;
import nl.aurorion.blockregen.util.Locations;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class RegenerationRegion
extends RegenerationArea {
    private final Location min;
    private final Location max;

    public RegenerationRegion(String name, Location min, Location max) {
        super(name);
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean contains(@NotNull Block block) {
        if (this.max.getWorld() != null && !this.max.getWorld().equals((Object)block.getWorld())) {
            return false;
        }
        return (double)block.getX() <= this.max.getX() && (double)block.getX() >= this.min.getX() && (double)block.getZ() <= this.max.getZ() && (double)block.getZ() >= this.min.getZ() && (double)block.getY() <= this.max.getY() && (double)block.getY() >= this.min.getY();
    }

    @Override
    public void serialize(ConfigurationSection section) {
        super.serialize(section);
        section.set("Min", (Object)Locations.locationToString(this.min));
        section.set("Max", (Object)Locations.locationToString(this.max));
    }

    @Override
    public String toString() {
        return "RegenerationRegion{min=" + this.min + ", max=" + this.max + ", name='" + this.name + '\'' + ", presets=" + this.presets + ", all=" + this.all + ", priority=" + this.priority + '}';
    }

    @Generated
    public Location getMin() {
        return this.min;
    }

    @Generated
    public Location getMax() {
        return this.max;
    }
}

