/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.util;

import com.google.common.base.Strings;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.ParseException;
import nl.aurorion.blockregen.xseries.XEnchantment;
import nl.aurorion.blockregen.xseries.XMaterial;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    @Generated
    private static final Logger log = Logger.getLogger(Parsing.class.getName());

    public static <T> T parse(@NotNull Supplier<T> callable, @NotNull String message) {
        try {
            return callable.get();
        }
        catch (Exception e) {
            throw new ParseException(message);
        }
    }

    @NotNull
    public static String notNull(@Nullable String input) {
        if (input == null) {
            throw new ParseException("Parsing input cannot be null.");
        }
        return input;
    }

    public static int parseInt(@Nullable String input) {
        return Parsing.parse(() -> Integer.parseInt(Parsing.notNull(input)), "Invalid integer.");
    }

    public static int parseInt(@Nullable String input, @NotNull String message) {
        return Parsing.parse(() -> Integer.parseInt(Parsing.notNull(input)), message);
    }

    public static int parseInt(@Nullable String input, int def) {
        try {
            return Integer.parseInt(Parsing.notNull(input).trim());
        }
        catch (NumberFormatException exception) {
            return def;
        }
    }

    public static double parseDouble(@Nullable String input, @NotNull String message) {
        return Parsing.parse(() -> Double.parseDouble(Parsing.notNull(input)), message);
    }

    @NotNull
    public static XEnchantment parseEnchantment(@NotNull String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            throw new ParseException("Enchantment input cannot be empty.");
        }
        XEnchantment xEnchantment = XEnchantment.of(input.trim()).orElseThrow(() -> new ParseException("Could not parse enchantment from '" + input + "'."));
        if (xEnchantment.get() == null) {
            throw new ParseException("Could not load enchantment from '" + input + "'.");
        }
        return xEnchantment;
    }

    @NotNull
    @Contract(value="null,_->fail")
    public static XMaterial parseMaterial(@Nullable String input, boolean blocksOnly) {
        if (Strings.isNullOrEmpty((String)input)) {
            throw new ParseException("Material input cannot be empty.");
        }
        XMaterial xMaterial = XMaterial.matchXMaterial(input).orElseThrow(() -> new ParseException("Could not parse material from '" + input + "'."));
        if (xMaterial.get() == null) {
            throw new ParseException("Could not load material from '" + input + "'.");
        }
        if (blocksOnly && !xMaterial.get().isBlock()) {
            throw new ParseException("Material '" + xMaterial + "' is not a block.");
        }
        return xMaterial;
    }

    @NotNull
    @Contract(value="null->fail")
    public static XMaterial parseMaterial(@Nullable String input) {
        return Parsing.parseMaterial(input, false);
    }

    public static <E extends Enum<E>> E parseEnum(String str, Class<E> clazz) {
        return Parsing.parseEnum(str, clazz, null);
    }

    public static <E extends Enum<E>> E parseEnum(String str, Class<E> clazz, Consumer<Throwable> exceptionCallback) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, str.trim().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            if (exceptionCallback != null) {
                exceptionCallback.accept(e);
            }
            return null;
        }
    }
}

