/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.version;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.util.logging.Logger;
import lombok.Generated;
import nl.aurorion.blockregen.BlockRegenPlugin;
import nl.aurorion.blockregen.util.Versions;
import nl.aurorion.blockregen.version.VersionManager;
import nl.aurorion.blockregen.version.ancient.AncientMethods;
import nl.aurorion.blockregen.version.ancient.AncientNodeData;
import nl.aurorion.blockregen.version.ancient.AncientNodeDataParser;
import nl.aurorion.blockregen.version.api.Methods;
import nl.aurorion.blockregen.version.api.NodeData;
import nl.aurorion.blockregen.version.api.NodeDataParser;
import nl.aurorion.blockregen.version.api.WorldEditProvider;
import nl.aurorion.blockregen.version.api.WorldGuardProvider;
import nl.aurorion.blockregen.version.current.LatestMethods;
import nl.aurorion.blockregen.version.current.LatestNodeData;
import nl.aurorion.blockregen.version.current.LatestNodeDataParser;
import nl.aurorion.blockregen.version.current.LatestWorldEditProvider;
import nl.aurorion.blockregen.version.current.LatestWorldGuardProvider;
import nl.aurorion.blockregen.version.current.PinkNodeData;
import nl.aurorion.blockregen.version.current.PinkNodeDataParser;
import nl.aurorion.blockregen.version.legacy.LegacyMethods;
import nl.aurorion.blockregen.version.legacy.LegacyNodeData;
import nl.aurorion.blockregen.version.legacy.LegacyNodeDataParser;
import nl.aurorion.blockregen.version.legacy.LegacyWorldEditProvider;
import nl.aurorion.blockregen.version.legacy.LegacyWorldGuardProvider;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class VersionManagerImpl
implements VersionManager {
    @Generated
    private static final Logger log = Logger.getLogger(VersionManagerImpl.class.getName());
    private final BlockRegenPlugin plugin;
    private final String version = this.loadNMSVersion();
    private WorldEditPlugin worldEdit;
    private WorldGuardPlugin worldGuard;
    private WorldEditProvider worldEditProvider;
    private WorldGuardProvider worldGuardProvider;
    private Methods methods;
    private VersionManager.NodeDataProvider nodeProvider;
    private NodeDataParser nodeDataParser;
    private boolean customModelData = false;

    public VersionManagerImpl(BlockRegenPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void load() {
        this.setupWorldEdit();
        this.setupWorldGuard();
        switch (this.version) {
            case "1.7": 
            case "1.8": {
                if (this.worldEdit != null) {
                    this.useWorldEdit(new LegacyWorldEditProvider(this.worldEdit));
                }
                if (this.worldGuard != null) {
                    this.useWorldGuard(new LegacyWorldGuardProvider(this.worldGuard));
                }
                this.methods = new AncientMethods();
                this.nodeProvider = AncientNodeData::new;
                this.nodeDataParser = new AncientNodeDataParser();
                break;
            }
            case "1.9": 
            case "1.10": 
            case "1.11": 
            case "1.12": {
                if (this.worldEdit != null) {
                    this.useWorldEdit(new LegacyWorldEditProvider(this.worldEdit));
                }
                if (this.worldGuard != null) {
                    this.useWorldGuard(new LegacyWorldGuardProvider(this.worldGuard));
                }
                this.methods = new LegacyMethods();
                this.nodeProvider = LegacyNodeData::new;
                this.nodeDataParser = new LegacyNodeDataParser();
                break;
            }
            case "1.13": {
                break;
            }
            case "1.14": 
            case "1.15": 
            case "1.16": 
            case "1.17": 
            case "1.18": 
            case "1.19": {
                if (this.worldEdit != null) {
                    this.useWorldEdit(new LatestWorldEditProvider(this.worldEdit));
                }
                if (this.worldGuard != null) {
                    this.useWorldGuard(new LatestWorldGuardProvider(this.worldGuard));
                }
                this.methods = new LatestMethods();
                this.nodeProvider = LatestNodeData::new;
                this.nodeDataParser = new LatestNodeDataParser();
                this.customModelData = true;
                break;
            }
            default: {
                if (this.worldEdit != null) {
                    this.useWorldEdit(new LatestWorldEditProvider(this.worldEdit));
                }
                if (this.worldGuard != null) {
                    this.useWorldGuard(new LatestWorldGuardProvider(this.worldGuard));
                }
                this.methods = new LatestMethods();
                this.nodeProvider = PinkNodeData::new;
                this.nodeDataParser = new PinkNodeDataParser();
                this.customModelData = true;
            }
        }
    }

    @Override
    public NodeData createNodeData() {
        return this.nodeProvider.provide();
    }

    private void useWorldGuard(WorldGuardProvider provider) {
        if (this.worldGuardProvider == null) {
            this.worldGuardProvider = provider;
        }
    }

    private void useWorldEdit(WorldEditProvider provider) {
        if (this.worldEditProvider == null) {
            this.worldEditProvider = provider;
        }
    }

    @Override
    public String loadNMSVersion() {
        String version = Bukkit.getServer().getBukkitVersion();
        int lastDot = (version = version.substring(0, version.indexOf("-"))).lastIndexOf(".");
        if (lastDot > 2) {
            version = version.substring(0, lastDot);
        }
        return version;
    }

    @Override
    public boolean isCurrentAbove(String versionString, boolean include) {
        int res = Versions.compareVersions(this.version, versionString, 2);
        return include ? res >= 0 : res > 0;
    }

    @Override
    public boolean isCurrentBelow(String versionString, boolean include) {
        int res = Versions.compareVersions(this.version, versionString, 2);
        return include ? res <= 0 : res < 0;
    }

    private void setupWorldEdit() {
        if (this.worldEditProvider != null) {
            return;
        }
        Plugin worldEditPlugin = this.plugin.getServer().getPluginManager().getPlugin("WorldEdit");
        if (!(worldEditPlugin instanceof WorldEditPlugin)) {
            return;
        }
        this.worldEdit = (WorldEditPlugin)worldEditPlugin;
        log.info("WorldEdit found! &aUsing it for regions.");
    }

    private void setupWorldGuard() {
        if (this.worldGuardProvider != null) {
            return;
        }
        Plugin worldGuardPlugin = this.plugin.getServer().getPluginManager().getPlugin("WorldGuard");
        if (!(worldGuardPlugin instanceof WorldGuardPlugin)) {
            return;
        }
        this.worldGuard = (WorldGuardPlugin)worldGuardPlugin;
        log.info("WorldGuard found! &aRespecting it's protection.");
    }

    @Override
    public boolean useCustomModelData() {
        return this.customModelData;
    }

    @Override
    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public WorldEditProvider getWorldEditProvider() {
        return this.worldEditProvider;
    }

    @Override
    @Generated
    public WorldGuardProvider getWorldGuardProvider() {
        return this.worldGuardProvider;
    }

    @Override
    @Generated
    public Methods getMethods() {
        return this.methods;
    }

    @Override
    @Generated
    public VersionManager.NodeDataProvider getNodeProvider() {
        return this.nodeProvider;
    }

    @Override
    @Generated
    public NodeDataParser getNodeDataParser() {
        return this.nodeDataParser;
    }
}

