/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.xseries.base;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import nl.aurorion.blockregen.xseries.base.XModuleMetadata;
import nl.aurorion.blockregen.xseries.base.XRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface XBase<XForm extends XBase<XForm, BukkitForm>, BukkitForm> {
    @NotNull
    @Contract(pure=true)
    public String name();

    @ApiStatus.Internal
    @Contract(pure=true)
    public String[] getNames();

    @NotNull
    @Contract(pure=true)
    default public String friendlyName() {
        return Arrays.stream(this.name().split("_")).map(t -> t.charAt(0) + t.substring(1).toLowerCase(Locale.ENGLISH)).collect(Collectors.joining(" "));
    }

    @Nullable
    @Contract(pure=true)
    public BukkitForm get();

    @Contract(pure=true)
    default public boolean isSupported() {
        return this.get() != null;
    }

    @NotNull
    @Contract(pure=true)
    default public XForm or(XForm other) {
        return (XForm)(this.isSupported() ? this : other);
    }

    @ApiStatus.Internal
    default public XModuleMetadata getMetadata() {
        XRegistry registry = XRegistry.registryOf(this.getClass());
        return registry.getOrRegisterMetadata(this, registry.getBackingField(this), false);
    }
}

