/*
 * Decompiled with CFR 0.152.
 */
package nl.aurorion.blockregen.xseries.profiles.objects.cache;

import com.mojang.authlib.GameProfile;
import nl.aurorion.blockregen.xseries.profiles.exceptions.MojangAPIRetryException;
import nl.aurorion.blockregen.xseries.profiles.objects.Profileable;
import nl.aurorion.blockregen.xseries.reflection.XReflection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class CacheableProfileable
implements Profileable {
    protected GameProfile cache;
    protected Throwable lastError;

    @Override
    public final synchronized GameProfile getProfile() {
        if (this.hasExpired(true)) {
            this.lastError = null;
            this.cache = null;
        }
        if (this.lastError != null && !(this.lastError instanceof MojangAPIRetryException)) {
            throw XReflection.throwCheckedException(this.lastError);
        }
        if (this.cache == null) {
            try {
                this.cache = this.cacheProfile();
                this.lastError = null;
            }
            catch (Throwable ex) {
                this.lastError = ex;
                throw ex;
            }
        }
        return this.cache;
    }

    public final boolean hasExpired() {
        return this.hasExpired(false);
    }

    @Override
    public final boolean isReady() {
        return !this.hasExpired(false);
    }

    protected boolean hasExpired(boolean renew) {
        return this.lastError instanceof MojangAPIRetryException;
    }

    @NotNull
    protected abstract GameProfile cacheProfile();

    public final String toString() {
        return this.getClass().getSimpleName() + "[cache=" + this.cache + ", lastError=" + this.lastError + ']';
    }
}

