/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintChildren;
import kr.toxicity.model.api.data.blueprint.BlueprintImage;
import kr.toxicity.model.api.data.blueprint.BlueprintTexture;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelData;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.util.PackUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public record ModelBlueprint(@NotNull String name, float scale, @NotNull ModelResolution resolution, @NotNull List<BlueprintTexture> textures, @NotNull List<BlueprintChildren> group, @NotNull Map<String, BlueprintAnimation> animations) {
    @NotNull
    public static ModelBlueprint from(@NotNull String name, @NotNull ModelData data) {
        Map<String, ModelElement> elementMap = data.elements().stream().collect(Collectors.toUnmodifiableMap(ModelElement::uuid, e -> e));
        ArrayList<BlueprintChildren> list = new ArrayList<BlueprintChildren>();
        for (ModelChildren modelChildren : data.outliner()) {
            BlueprintChildren children = BlueprintChildren.from(modelChildren, elementMap);
            list.add(children);
        }
        return new ModelBlueprint(name, data.scale(), data.resolution(), data.textures().stream().map(BlueprintTexture::from).toList(), list, data.animations().stream().map(BlueprintAnimation::from).collect(Collectors.toUnmodifiableMap(BlueprintAnimation::name, a -> a)));
    }

    @NotNull
    public List<BlueprintImage> buildImage() {
        ArrayList<BlueprintImage> list = new ArrayList<BlueprintImage>();
        for (BlueprintTexture texture : this.textures) {
            list.add(new BlueprintImage(PackUtil.toPackName(this.name + "_" + texture.name()), texture.image(), texture.isAnimatedTexture() ? texture.toMcmeta() : null));
        }
        return list;
    }
}

