/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface ModelRotator
extends BiFunction<Tracker, ModelRotation, ModelRotation>
permits SourcedRotator, Deserializer.Pack {
    public static final Deserializer DESERIALIZER = new Deserializer();
    public static final ModelRotator DEFAULT = Objects.requireNonNull(ModelRotator.DESERIALIZER._default.apply());
    public static final ModelRotator EMPTY = Objects.requireNonNull(ModelRotator.DESERIALIZER.empty.apply());
    public static final ModelRotator PITCH = Objects.requireNonNull(ModelRotator.DESERIALIZER.pitch.apply());
    public static final ModelRotator YAW = Objects.requireNonNull(ModelRotator.DESERIALIZER.yaw.apply());

    @NotNull
    public static ModelRotator deserialize(@NotNull JsonObject object) {
        ModelRotator result = DESERIALIZER.deserialize(object);
        return result != null ? result : EMPTY;
    }

    @NotNull
    public String name();

    @Nullable
    public ModelRotator source();

    @Nullable
    public JsonElement data();

    @NotNull
    default public JsonObject serialize() {
        ModelRotator s;
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name());
        JsonElement d = this.data();
        if (d != null) {
            json.add("data", d);
        }
        if ((s = this.source()) != null) {
            json.add("source", (JsonElement)s.serialize());
        }
        return json;
    }

    @NotNull
    default public ModelRotation apply(@NotNull Tracker tracker) {
        return this.apply(tracker, ModelRotation.EMPTY);
    }

    @Override
    @NotNull
    public ModelRotation apply(@NotNull Tracker var1, @NotNull ModelRotation var2);

    @NotNull
    default public ModelRotator then(@NotNull ModelRotator rotator) {
        return new SourcedRotator(this, rotator);
    }

    public static final class Deserializer {
        private final Map<String, Builder> builderMap = new HashMap<String, Builder>();
        private final BuiltInDeserializer _default = this.register("empty", j -> Getter.of(r -> r));
        private final BuiltInDeserializer empty = this.register("empty", j -> Getter.of(ModelRotation.EMPTY));
        private final BuiltInDeserializer yaw = this.register("yaw", j -> Getter.of(ModelRotation::yaw));
        private final BuiltInDeserializer pitch = this.register("pitch", j -> Getter.of(ModelRotation::pitch));

        private Deserializer() {
        }

        @NotNull
        public BuiltInDeserializer register(@NotNull String name, @NotNull Builder builder) {
            Builder get = this.builderMap.putIfAbsent(name, builder);
            Builder selected = get != null ? get : builder;
            return e -> {
                JsonElement source;
                Getter build = selected.build(e);
                JsonElement jsonElement = source = e.isJsonObject() ? e.getAsJsonObject().get("source") : null;
                return build != null ? this.pack(name, source != null && source.isJsonObject() ? this.deserialize(source.getAsJsonObject()) : null, e, build) : null;
            };
        }

        @Nullable
        public ModelRotator deserialize(@NotNull JsonObject object) {
            JsonPrimitive rawName = object.getAsJsonPrimitive("name");
            if (rawName == null) {
                return null;
            }
            String name = rawName.getAsString();
            Builder get = this.builderMap.get(name);
            if (get == null) {
                return null;
            }
            JsonElement data = object.get("data");
            JsonElement source = object.getAsJsonObject().get("source");
            Getter build = get.build((JsonElement)(data == null ? JsonNull.INSTANCE : data));
            return build != null ? this.pack(name, source != null && source.isJsonObject() ? this.deserialize(source.getAsJsonObject()) : null, data, build) : null;
        }

        @NotNull
        private Pack pack(@NotNull String name, @Nullable ModelRotator source, @Nullable JsonElement data, @NotNull Getter getter) {
            return new Pack(name, source, data, getter);
        }

        private record Pack(@NotNull String name, @Nullable ModelRotator source, @Nullable JsonElement data, @NotNull Getter delegate) implements ModelRotator
        {
            @Override
            @NotNull
            public ModelRotation apply(@NotNull Tracker tracker, @NotNull ModelRotation modelRotation) {
                return this.delegate.apply(tracker, modelRotation);
            }
        }
    }

    public record SourcedRotator(@NotNull ModelRotator source, @NotNull ModelRotator delegate) implements ModelRotator
    {
        @Override
        @NotNull
        public String name() {
            return this.delegate.name();
        }

        @Override
        @Nullable
        public JsonElement data() {
            return this.delegate.data();
        }

        @Override
        @NotNull
        public ModelRotation apply(@NotNull Tracker tracker, @NotNull ModelRotation rotation) {
            return this.delegate.apply(tracker, this.source.apply(tracker, rotation));
        }
    }

    public static interface BuiltInDeserializer
    extends Function<JsonElement, ModelRotator> {
        @Override
        @Nullable
        public ModelRotator apply(@NotNull JsonElement var1);

        @Nullable
        default public ModelRotator apply() {
            return this.apply((JsonElement)JsonNull.INSTANCE);
        }
    }

    public static interface Builder {
        @Nullable
        public Getter build(@NotNull JsonElement var1);
    }

    public static interface Getter {
        public static final Getter DEFAULT = Getter.of((ModelRotation r) -> r);

        @NotNull
        public ModelRotation apply(@NotNull Tracker var1, @NotNull ModelRotation var2);

        @NotNull
        public static Getter of(@NotNull ModelRotation rotator) {
            return (t, r) -> rotator;
        }

        @NotNull
        public static Getter of(@NotNull Supplier<ModelRotation> rotator) {
            return (t, r) -> (ModelRotation)rotator.get();
        }

        @NotNull
        public static Getter of(@NotNull Function<ModelRotation, ModelRotation> rotator) {
            return (t, r) -> (ModelRotation)rotator.apply(r);
        }
    }
}

