/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.renderer.ModelRenderer;
import kr.toxicity.model.api.data.renderer.RenderPipeline;
import kr.toxicity.model.api.event.CloseTrackerEvent;
import kr.toxicity.model.api.event.ModelDespawnAtPlayerEvent;
import kr.toxicity.model.api.event.ModelSpawnAtPlayerEvent;
import kr.toxicity.model.api.event.PlayerHideTrackerEvent;
import kr.toxicity.model.api.event.PlayerShowTrackerEvent;
import kr.toxicity.model.api.manager.ConfigManager;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.ModelRotator;
import kr.toxicity.model.api.tracker.ModelScaler;
import kr.toxicity.model.api.tracker.TrackerData;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class Tracker
implements AutoCloseable {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(256);
    protected final RenderPipeline pipeline;
    private final ScheduledFuture<?> task;
    private final Queue<Runnable> queuedTask = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean readyForForceUpdate = new AtomicBoolean();
    private final AtomicBoolean forRemoval = new AtomicBoolean();
    private final TrackerModifier modifier;
    private final Runnable updater;
    private PacketBundler viewBundler;
    private PacketBundler dataBundler;
    private long frame = 0L;
    private ModelRotator rotator = ModelRotator.YAW;
    private ModelScaler scaler = ModelScaler.entity();
    private Supplier<ModelRotation> rotationSupplier = () -> ModelRotation.EMPTY;
    private Consumer<Tracker> closeEventHandler = t -> EventUtil.call(new CloseTrackerEvent((Tracker)t));
    private BiConsumer<Tracker, PacketBundler> consumer = (t, b2) -> {};

    public Tracker(@NotNull RenderPipeline pipeline, @NotNull TrackerModifier modifier) {
        this.pipeline = pipeline;
        this.modifier = modifier;
        this.viewBundler = pipeline.createBundler();
        this.dataBundler = pipeline.createBundler();
        ConfigManager config = BetterModel.plugin().configManager();
        this.updater = () -> {
            boolean isMinecraftTickTime;
            boolean bl = isMinecraftTickTime = this.frame % 5L == 0L;
            if (isMinecraftTickTime) {
                Runnable task;
                while ((task = this.queuedTask.poll()) != null) {
                    task.run();
                }
            }
            pipeline.move(isMinecraftTickTime ? (this.isRunningSingleAnimation() && config.lockOnPlayAnimation() ? pipeline.getRotation() : this.rotation()) : null, this.viewBundler);
            this.consumer.accept(this, this.viewBundler);
            if (this.readyForForceUpdate.compareAndSet(true, false)) {
                pipeline.forceUpdate(this.dataBundler);
            }
            if (!this.dataBundler.isEmpty()) {
                pipeline.nonHidePlayer().forEach(this.dataBundler::send);
                this.dataBundler = pipeline.createBundler();
            }
            if (!this.viewBundler.isEmpty()) {
                pipeline.viewedPlayer().forEach(this.viewBundler::send);
                this.viewBundler = pipeline.createBundler();
            }
        };
        this.task = EXECUTOR.scheduleAtFixedRate(() -> {
            if (this.playerCount() > 0 || this.forRemoval.get()) {
                this.updater.run();
            }
            ++this.frame;
        }, 10L, 10L, TimeUnit.MILLISECONDS);
        if (modifier.sightTrace()) {
            pipeline.viewFilter(p -> EntityUtil.canSee(p.getEyeLocation(), this.location()));
        }
        this.tick((t, b2) -> t.pipeline.getScriptProcessor().tick());
    }

    @NotNull
    public ModelRotation rotation() {
        return this.rotator.apply(this, this.rotationSupplier.get());
    }

    public final void rotation(@NotNull Supplier<ModelRotation> supplier) {
        this.rotationSupplier = Objects.requireNonNull(supplier);
    }

    public final void rotator(@NotNull ModelRotator rotator) {
        this.rotator = Objects.requireNonNull(rotator);
    }

    @NotNull
    public ModelScaler scaler() {
        return this.scaler;
    }

    public void scaler(@NotNull ModelScaler scaler) {
        this.scaler = Objects.requireNonNull(scaler);
    }

    @NotNull
    public TrackerData asTrackerData() {
        return new TrackerData(this.pipeline.name(), this.scaler, this.rotator, this.modifier);
    }

    public void task(@NotNull Runnable runnable) {
        this.queuedTask.add(Objects.requireNonNull(runnable));
    }

    public void frame(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.consumer = this.consumer.andThen(Objects.requireNonNull(consumer));
    }

    public void tick(@NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.tick(1L, consumer);
    }

    public void tick(long tick, @NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        this.schedule(5L * tick, consumer);
    }

    public void schedule(long period, @NotNull BiConsumer<Tracker, PacketBundler> consumer) {
        Objects.requireNonNull(consumer);
        if (period <= 0L) {
            throw new RuntimeException("period cannot be <= 0");
        }
        this.frame((t, b2) -> {
            if (this.frame % period == 0L) {
                consumer.accept((Tracker)t, (PacketBundler)b2);
            }
        });
    }

    protected void update() {
        this.updater.run();
    }

    @NotNull
    public String name() {
        return this.pipeline.getParent().name();
    }

    public double height() {
        return this.pipeline.height();
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.closeEventHandler.accept(this);
            this.task.cancel(true);
            this.pipeline.despawn();
        }
    }

    public void despawn() {
        if (!this.isClosed()) {
            this.pipeline.despawn();
        }
    }

    @NotNull
    public TrackerModifier modifier() {
        return this.modifier;
    }

    public boolean forceUpdate(boolean force) {
        boolean get = this.readyForForceUpdate.get();
        return this.readyForForceUpdate.compareAndSet(get, force);
    }

    public boolean isRunningSingleAnimation() {
        RenderedBone.RunningAnimation runningAnimation = this.pipeline.runningAnimation();
        return runningAnimation != null && runningAnimation.type() == AnimationIterator.Type.PLAY_ONCE;
    }

    protected boolean spawn(@NotNull Player player, @NotNull PacketBundler bundler) {
        if (this.isClosed()) {
            return false;
        }
        if (!EventUtil.call(new ModelSpawnAtPlayerEvent(player, this))) {
            return false;
        }
        return this.pipeline.spawn(player, bundler);
    }

    public boolean remove(@NotNull Player player) {
        if (this.isClosed()) {
            return false;
        }
        EventUtil.call(new ModelDespawnAtPlayerEvent(player, this));
        return this.pipeline.remove(player);
    }

    public int playerCount() {
        return this.pipeline.playerCount();
    }

    @NotNull
    public Stream<Player> viewedPlayer() {
        return this.pipeline.viewedPlayer();
    }

    public void tint(int rgb) {
        this.tint(BonePredicate.TRUE, rgb);
    }

    public void tint(@NotNull BonePredicate predicate, int rgb) {
        if (this.pipeline.tint(predicate, rgb)) {
            this.forceUpdate(true);
        }
    }

    @NotNull
    public abstract Location location();

    @NotNull
    public abstract UUID uuid();

    public boolean animate(@NotNull String animation) {
        return this.animate(animation, AnimationModifier.DEFAULT);
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier) {
        return this.animate(animation, modifier, () -> {});
    }

    public boolean animate(@NotNull String animation, AnimationModifier modifier, Runnable removeTask) {
        return this.animate((RenderedBone e) -> true, animation, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull String animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        return this.pipeline.animate(filter, animation, modifier, removeTask);
    }

    public boolean animate(@NotNull Predicate<RenderedBone> filter, @NotNull BlueprintAnimation animation, @NotNull AnimationModifier modifier, @NotNull Runnable removeTask) {
        return this.pipeline.animate(filter, animation, modifier, removeTask);
    }

    public void stopAnimation(@NotNull String animation) {
        this.stopAnimation(e -> true, animation);
    }

    public void stopAnimation(@NotNull Predicate<RenderedBone> filter, @NotNull String animation) {
        this.pipeline.stopAnimation(filter, animation);
    }

    public boolean replace(@NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.replace(t -> true, target, animation, modifier);
    }

    public boolean replace(@NotNull Predicate<RenderedBone> filter, @NotNull String target, @NotNull String animation, @NotNull AnimationModifier modifier) {
        return this.pipeline.replace(filter, target, animation, modifier);
    }

    public boolean togglePart(@NotNull BonePredicate predicate, boolean toggle) {
        return this.pipeline.togglePart(predicate, toggle);
    }

    public boolean itemStack(@NotNull BonePredicate predicate, @NotNull TransformedItemStack itemStack) {
        return this.pipeline.itemStack(predicate, itemStack);
    }

    public boolean glow(@NotNull BonePredicate predicate, boolean glow, int glowColor) {
        return this.pipeline.glow(predicate, glow, glowColor);
    }

    public boolean enchant(@NotNull BonePredicate predicate, boolean enchant) {
        return this.pipeline.enchant(predicate, enchant);
    }

    public boolean brightness(@NotNull BonePredicate predicate, int block, int sky) {
        return this.pipeline.brightness(predicate, block, sky);
    }

    public boolean updateItem(@NotNull BonePredicate predicate) {
        return this.pipeline.updateItem(predicate);
    }

    @Nullable
    public RenderedBone bone(@NotNull BoneName name) {
        return this.bone((RenderedBone b2) -> b2.getName().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull String name) {
        return this.bone((RenderedBone b2) -> b2.getName().name().equals(name));
    }

    @Nullable
    public RenderedBone bone(@NotNull Predicate<RenderedBone> predicate) {
        return this.pipeline.boneOf(predicate);
    }

    @NotNull
    public @Unmodifiable List<RenderedBone> bones() {
        return this.pipeline.bones();
    }

    @NotNull
    public Stream<ModelDisplay> displays() {
        return this.bones().stream().map(RenderedBone::getDisplay).filter(Objects::nonNull);
    }

    public boolean hide(@NotNull Player player) {
        return EventUtil.call(new PlayerHideTrackerEvent(this, player)) && this.pipeline.hide(player);
    }

    public boolean isHide(@NotNull Player player) {
        return this.pipeline.isHide(player);
    }

    public boolean show(@NotNull Player player) {
        return EventUtil.call(new PlayerShowTrackerEvent(this, player)) && this.pipeline.show(player);
    }

    public void handleCloseEvent(@NotNull Consumer<Tracker> consumer) {
        this.closeEventHandler = this.closeEventHandler.andThen(Objects.requireNonNull(consumer));
    }

    @NotNull
    public ModelRenderer renderer() {
        return this.pipeline.getParent();
    }

    @ApiStatus.Internal
    public void forRemoval(boolean removal) {
        this.forRemoval.set(removal);
    }

    @ApiStatus.Internal
    public boolean forRemoval() {
        return this.forRemoval.get();
    }

    @Generated
    public RenderPipeline getPipeline() {
        return this.pipeline;
    }
}

