/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kotlin.uuid;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import kr.toxicity.model.shaded.kotlin.Deprecated;
import kr.toxicity.model.shaded.kotlin.DeprecatedSinceKotlin;
import kr.toxicity.model.shaded.kotlin.ExperimentalUnsignedTypes;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.PublishedApi;
import kr.toxicity.model.shaded.kotlin.ReplaceWith;
import kr.toxicity.model.shaded.kotlin.SinceKotlin;
import kr.toxicity.model.shaded.kotlin.UByteArray;
import kr.toxicity.model.shaded.kotlin.ULong;
import kr.toxicity.model.shaded.kotlin.comparisons.ComparisonsKt;
import kr.toxicity.model.shaded.kotlin.internal.InlineOnly;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function2;
import kr.toxicity.model.shaded.kotlin.jvm.internal.DefaultConstructorMarker;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.text.StringsKt;
import kr.toxicity.model.shaded.kotlin.uuid.ExperimentalUuidApi;
import kr.toxicity.model.shaded.kotlin.uuid.UuidKt;
import kr.toxicity.model.shaded.kotlin.uuid.UuidKt__UuidKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00000\u00012\u00060\u0002j\u0002`\u0003:\u00010B\u0019\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\\\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J\\\u0010\u0016\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u001026\u0010\u0011\u001a2\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0004\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u0002H\u00100\u0012H\u0087\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0007J\u0006\u0010\u001b\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000f\u0010\u001e\u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b \u0010!J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0096\u0002J\u0011\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0000H\u0097\u0002J\b\u0010(\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020%H\u0002J\u0019\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060-j\u0002`.H\u0002\u00a2\u0006\u0002\u0010/R\u001c\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lkr/toxicity/model/shaded/kotlin/uuid/Uuid;", "", "Ljava/io/Serializable;", "Lkr/toxicity/model/shaded/kotlin/io/Serializable;", "mostSignificantBits", "", "leastSignificantBits", "<init>", "(JJ)V", "getMostSignificantBits$annotations", "()V", "getMostSignificantBits", "()J", "getLeastSignificantBits$annotations", "getLeastSignificantBits", "toLongs", "T", "action", "Lkr/toxicity/model/shaded/kotlin/Function2;", "Lkr/toxicity/model/shaded/kotlin/ParameterName;", "name", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "toULongs", "Lkr/toxicity/model/shaded/kotlin/ULong;", "toString", "", "toHexDashString", "toHexString", "toByteArray", "", "toUByteArray", "Lkr/toxicity/model/shaded/kotlin/UByteArray;", "toUByteArray-TcUX1vc", "()[B", "equals", "", "other", "", "compareTo", "", "hashCode", "writeReplace", "readObject", "", "input", "Ljava/io/ObjectInputStream;", "Lkr/toxicity/model/shaded/kotlin/internal/ReadObjectParameterType;", "(Ljava/io/ObjectInputStream;)V", "Companion", "kr.toxicity.model.shaded.kotlin-stdlib"})
@SinceKotlin(version="2.0")
@ExperimentalUuidApi
public final class Uuid
implements Comparable<Uuid>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    @NotNull
    private static final Uuid NIL = new Uuid(0L, 0L);
    public static final int SIZE_BYTES = 16;
    public static final int SIZE_BITS = 128;

    private Uuid(long mostSignificantBits, long leastSignificantBits) {
        this.mostSignificantBits = mostSignificantBits;
        this.leastSignificantBits = leastSignificantBits;
    }

    public final long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getMostSignificantBits$annotations() {
    }

    public final long getLeastSignificantBits() {
        return this.leastSignificantBits;
    }

    @PublishedApi
    public static /* synthetic */ void getLeastSignificantBits$annotations() {
    }

    @InlineOnly
    private final <T> T toLongs(Function2<? super Long, ? super Long, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return action.invoke(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    @InlineOnly
    private final <T> T toULongs(Function2<? super ULong, ? super ULong, ? extends T> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        return action.invoke(ULong.box-impl(ULong.constructor-impl(this.getMostSignificantBits())), ULong.box-impl(ULong.constructor-impl(this.getLeastSignificantBits())));
    }

    @NotNull
    public String toString() {
        return this.toHexDashString();
    }

    @SinceKotlin(version="2.1")
    @NotNull
    public final String toHexDashString() {
        byte[] bytes = new byte[36];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 4);
        bytes[8] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 9, 4, 6);
        bytes[13] = 45;
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 14, 6, 8);
        bytes[18] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 19, 0, 2);
        bytes[23] = 45;
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 24, 2, 8);
        return StringsKt.decodeToString(bytes);
    }

    @NotNull
    public final String toHexString() {
        byte[] bytes = new byte[32];
        UuidKt.formatBytesInto(this.mostSignificantBits, bytes, 0, 0, 8);
        UuidKt.formatBytesInto(this.leastSignificantBits, bytes, 16, 0, 8);
        return StringsKt.decodeToString(bytes);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] bytes = new byte[16];
        UuidKt.setLongAt(bytes, 0, this.mostSignificantBits);
        UuidKt.setLongAt(bytes, 8, this.leastSignificantBits);
        return bytes;
    }

    @SinceKotlin(version="2.1")
    @ExperimentalUnsignedTypes
    @NotNull
    public final byte[] toUByteArray-TcUX1vc() {
        return UByteArray.constructor-impl(this.toByteArray());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)other).mostSignificantBits && this.leastSignificantBits == ((Uuid)other).leastSignificantBits;
    }

    @Override
    @SinceKotlin(version="2.1")
    public int compareTo(@NotNull Uuid other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this.mostSignificantBits != other.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(this.mostSignificantBits), ULong.constructor-impl(other.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(this.leastSignificantBits), ULong.constructor-impl(other.leastSignificantBits));
    }

    public int hashCode() {
        return Long.hashCode(this.mostSignificantBits ^ this.leastSignificantBits);
    }

    private final Object writeReplace() {
        return UuidKt.serializedUuid(this);
    }

    private final void readObject(ObjectInputStream input) {
        throw new InvalidObjectException("Deserialization is supported via proxy only");
    }

    public /* synthetic */ Uuid(long mostSignificantBits, long leastSignificantBits, DefaultConstructorMarker $constructor_marker) {
        this(mostSignificantBits, leastSignificantBits);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J\u0017\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u001dH\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001dJ\u0006\u0010\"\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u00050$j\b\u0012\u0004\u0012\u00020\u0005`%8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0003\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lkr/toxicity/model/shaded/kotlin/uuid/Uuid$Companion;", "", "<init>", "()V", "NIL", "Lkr/toxicity/model/shaded/kotlin/uuid/Uuid;", "getNIL", "()Lkotlin/uuid/Uuid;", "SIZE_BYTES", "", "SIZE_BITS", "fromLongs", "mostSignificantBits", "", "leastSignificantBits", "fromULongs", "Lkr/toxicity/model/shaded/kotlin/ULong;", "fromULongs-eb3DHEI", "(JJ)Lkotlin/uuid/Uuid;", "fromByteArray", "byteArray", "", "fromUByteArray", "ubyteArray", "Lkr/toxicity/model/shaded/kotlin/UByteArray;", "fromUByteArray-GBYM_sE", "([B)Lkotlin/uuid/Uuid;", "parse", "uuidString", "", "parseHexDash", "hexDashString", "parseHex", "hexString", "random", "LEXICAL_ORDER", "Ljava/util/Comparator;", "Lkr/toxicity/model/shaded/kotlin/Comparator;", "getLEXICAL_ORDER$annotations", "getLEXICAL_ORDER", "()Ljava/util/Comparator;", "kr.toxicity.model.shaded.kotlin-stdlib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Uuid getNIL() {
            return NIL;
        }

        @NotNull
        public final Uuid fromLongs(long mostSignificantBits, long leastSignificantBits) {
            return mostSignificantBits == 0L && leastSignificantBits == 0L ? this.getNIL() : new Uuid(mostSignificantBits, leastSignificantBits, null);
        }

        @NotNull
        public final Uuid fromULongs-eb3DHEI(long mostSignificantBits, long leastSignificantBits) {
            return this.fromLongs(mostSignificantBits, leastSignificantBits);
        }

        @NotNull
        public final Uuid fromByteArray(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter(byteArray, "byteArray");
            if (!(byteArray.length == 16)) {
                boolean bl = false;
                String string = "Expected exactly 16 bytes, but was " + UuidKt__UuidKt.access$truncateForErrorMessage(byteArray, 32) + " of size " + byteArray.length;
                throw new IllegalArgumentException(string.toString());
            }
            return this.fromLongs(UuidKt.getLongAt(byteArray, 0), UuidKt.getLongAt(byteArray, 8));
        }

        @SinceKotlin(version="2.1")
        @ExperimentalUnsignedTypes
        @NotNull
        public final Uuid fromUByteArray-GBYM_sE(@NotNull byte[] ubyteArray) {
            Intrinsics.checkNotNullParameter(ubyteArray, "ubyteArray");
            return this.fromByteArray(ubyteArray);
        }

        @NotNull
        public final Uuid parse(@NotNull String uuidString) {
            Uuid uuid;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            switch (uuidString.length()) {
                case 36: {
                    uuid = UuidKt.uuidParseHexDash(uuidString);
                    break;
                }
                case 32: {
                    uuid = UuidKt.uuidParseHex(uuidString);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Expected either a 36-char string in the standard hex-and-dash UUID format or a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(uuidString, 64) + "\" of length " + uuidString.length());
                }
            }
            return uuid;
        }

        @SinceKotlin(version="2.1")
        @NotNull
        public final Uuid parseHexDash(@NotNull String hexDashString) {
            Intrinsics.checkNotNullParameter(hexDashString, "hexDashString");
            if (!(hexDashString.length() == 36)) {
                boolean bl = false;
                String string = "Expected a 36-char string in the standard hex-and-dash UUID format, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexDashString, 64) + "\" of length " + hexDashString.length();
                throw new IllegalArgumentException(string.toString());
            }
            return UuidKt.uuidParseHexDash(hexDashString);
        }

        @NotNull
        public final Uuid parseHex(@NotNull String hexString) {
            Intrinsics.checkNotNullParameter(hexString, "hexString");
            if (!(hexString.length() == 32)) {
                boolean bl = false;
                String string = "Expected a 32-char hexadecimal string, but was \"" + UuidKt__UuidKt.access$truncateForErrorMessage(hexString, 64) + "\" of length " + hexString.length();
                throw new IllegalArgumentException(string.toString());
            }
            return UuidKt.uuidParseHex(hexString);
        }

        @NotNull
        public final Uuid random() {
            return UuidKt.secureRandomUuid();
        }

        @NotNull
        public final Comparator<Uuid> getLEXICAL_ORDER() {
            return ComparisonsKt.naturalOrder();
        }

        @Deprecated(message="Use naturalOrder<Uuid>() instead", replaceWith=@ReplaceWith(expression="naturalOrder<Uuid>()", imports={"kr.toxicity.model.shaded.kotlin.comparisons.naturalOrder"}))
        @DeprecatedSinceKotlin(warningSince="2.1")
        public static /* synthetic */ void getLEXICAL_ORDER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

