/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.ElementVector;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.ModelJson;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVFace;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVIndexer;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVMappedFace;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVModelData;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVNamespace;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVPos;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVSpace;
import kr.toxicity.model.shaded.kr.toxicity.library.dynamicuv.UVUtil;
import org.jetbrains.annotations.NotNull;

public final class UVElement {
    private final Map<UVFace, UVPos> mappingPos;
    private final ElementVector from;
    private final ElementVector to;
    private final ElementVector pixel;
    private final UVSpace space;
    private final ColorType colorType;
    private final List<UVMappedFace> faces;

    public UVElement(@NotNull ElementVector scale, @NotNull ElementVector position, @NotNull UVSpace space, @NotNull ColorType colorType, @NotNull Map<UVFace, UVPos> mappingPos) {
        ElementVector center = scale.toModelLocation();
        this.space = space;
        this.mappingPos = new EnumMap<UVFace, UVPos>(mappingPos);
        this.colorType = colorType;
        ElementVector centerPos = position.toModelLocation().plus(ElementVector.CENTER);
        this.from = center.div(-2.0f).plus(centerPos);
        this.to = center.div(2.0f).plus(centerPos);
        this.pixel = center.div(space.x(), space.y(), space.z());
        ArrayList list = new ArrayList();
        for (UVFace value : this.mappingPos.keySet()) {
            value.iterate(this, list::add);
        }
        this.faces = Collections.unmodifiableList(list);
    }

    @NotNull
    public ColorType colorType() {
        return this.colorType;
    }

    @NotNull
    public ElementVector from() {
        return this.from;
    }

    @NotNull
    public List<UVMappedFace> faces() {
        return this.faces;
    }

    @NotNull
    public UVSpace space() {
        return this.space;
    }

    @NotNull
    public ElementVector pixel() {
        return this.pixel;
    }

    @NotNull
    public ElementVector to() {
        return this.to;
    }

    void write(@NotNull UVModelData.Builder builder, @NotNull BufferedImage image) {
        for (Map.Entry<UVFace, UVPos> entry : this.mappingPos.entrySet()) {
            entry.getValue().iterate(entry.getKey().posOf(this.space), (x, z) -> this.colorType.write(builder, x < image.getWidth() && z < image.getHeight() ? image.getRGB(x, z) : 0));
        }
    }

    @NotNull
    public JsonObject asJson(@NotNull String textureName) {
        JsonObject obj = new JsonObject();
        JsonObject textures = new JsonObject();
        textures.addProperty("0", textureName);
        textures.addProperty("particle", textureName);
        obj.add("textures", (JsonElement)textures);
        JsonArray elements = new JsonArray(this.faces.size());
        for (UVMappedFace face : this.faces) {
            elements.add((JsonElement)face.asJson(0));
        }
        obj.add("elements", (JsonElement)elements);
        return obj;
    }

    @NotNull
    List<JsonObject> asJson(@NotNull UVNamespace namespace, @NotNull UVIndexer indexer, @NotNull List<ModelJson> modelJsons) {
        return this.colorType.asJson(namespace, indexer, modelJsons);
    }

    @NotNull
    List<ModelJson> pack(@NotNull String modelName, @NotNull String textureName, @NotNull UVIndexer indexer) {
        return this.colorType.pack(modelName, textureName, indexer, this.faces);
    }

    public static enum ColorType {
        RGB{

            @Override
            void write( @NotNull UVModelData.Builder builder, int value) {
                builder.colors().add(UVUtil.rgb(value));
            }

            @Override
            @NotNull
            List<ModelJson> pack(@NotNull String modelName, @NotNull String textureName, @NotNull UVIndexer indexer, @NotNull List<UVMappedFace> faces) {
                JsonArray array = new JsonArray(faces.size());
                int i = 0;
                for (UVMappedFace face : faces) {
                    array.add((JsonElement)face.asJson(i++));
                }
                return Collections.singletonList(new ModelJson(modelName + "_" + indexer.model(), UVUtil.packModel(textureName, array), faces.size()));
            }

            @Override
            @NotNull
            List<JsonObject> asJson(@NotNull UVNamespace namespace, @NotNull UVIndexer indexer, @NotNull List<ModelJson> modelJsons) {
                return modelJsons.stream().map(json -> UVUtil.model(namespace, json.name(), indexer, json.elements())).toList();
            }
        }
        ,
        ARGB{
            private static final JsonObject EMPTY = new JsonObject();

            @Override
            void write( @NotNull UVModelData.Builder builder, int value) {
                builder.colors().add(UVUtil.rgb(value));
                builder.flags().add(UVUtil.alpha(value));
            }

            @Override
            @NotNull
            List<JsonObject> asJson(@NotNull UVNamespace namespace, @NotNull UVIndexer indexer, @NotNull List<ModelJson> modelJsons) {
                return modelJsons.stream().map(json -> UVUtil.model(namespace, json.name(), indexer, json.elements())).map(rgb -> {
                    JsonObject obj = new JsonObject();
                    obj.addProperty("type", "minecraft:condition");
                    obj.addProperty("property", "minecraft:custom_model_data");
                    obj.addProperty("index", (Number)indexer.flag());
                    obj.add("on_true", (JsonElement)rgb);
                    obj.add("on_false", (JsonElement)EMPTY);
                    return obj;
                }).toList();
            }

            @Override
            @NotNull
            List<ModelJson> pack(@NotNull String modelName, @NotNull String textureName, @NotNull UVIndexer indexer, @NotNull List<UVMappedFace> faces) {
                return faces.stream().map(face -> new ModelJson(modelName + "_" + indexer.model(), face.asJson(textureName), 1)).toList();
            }

            static {
                EMPTY.addProperty("type", "empty");
            }
        };


        abstract void write(@NotNull UVModelData.Builder var1, int var2);

        @NotNull
        abstract List<JsonObject> asJson(@NotNull UVNamespace var1, @NotNull UVIndexer var2, @NotNull List<ModelJson> var3);

        @NotNull
        abstract List<ModelJson> pack(@NotNull String var1, @NotNull String var2, @NotNull UVIndexer var3, @NotNull List<UVMappedFace> var4);
    }
}

