/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.nms;

import org.bukkit.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public interface EntityAdapter {
    public static final EntityAdapter EMPTY = new EntityAdapter(){

        @Override
        public boolean dead() {
            return false;
        }

        @Override
        @Nullable
        public LivingEntity entity() {
            return null;
        }

        @Override
        public boolean invisible() {
            return false;
        }

        @Override
        public boolean glow() {
            return false;
        }

        @Override
        public boolean onWalk() {
            return false;
        }

        @Override
        public double scale() {
            return 1.0;
        }

        @Override
        public float bodyYaw() {
            return 0.0f;
        }

        @Override
        public float pitch() {
            return 0.0f;
        }

        @Override
        public float yaw() {
            return 0.0f;
        }

        @Override
        public float damageTick() {
            return 0.0f;
        }

        @Override
        public float walkSpeed() {
            return 1.0f;
        }

        @Override
        public boolean fly() {
            return false;
        }

        @Override
        @NotNull
        public Vector3f passengerPosition() {
            return new Vector3f();
        }
    };

    default public EntityAdapter multiply(double scaleMultiplier) {
        return new Multiplier(this, scaleMultiplier);
    }

    @Nullable
    public LivingEntity entity();

    public boolean dead();

    public boolean invisible();

    public boolean glow();

    public boolean onWalk();

    public boolean fly();

    public double scale();

    public float pitch();

    public float bodyYaw();

    public float yaw();

    public float damageTick();

    public float walkSpeed();

    @NotNull
    public Vector3f passengerPosition();

    public record Multiplier(@NotNull EntityAdapter delegate, double scaleMultiplier) implements EntityAdapter
    {
        @Override
        public boolean dead() {
            return this.delegate.dead();
        }

        @Override
        @Nullable
        public LivingEntity entity() {
            return this.delegate.entity();
        }

        @Override
        public boolean invisible() {
            return this.delegate.invisible();
        }

        @Override
        public boolean glow() {
            return this.delegate.glow();
        }

        @Override
        public boolean onWalk() {
            return this.delegate.onWalk();
        }

        @Override
        public float pitch() {
            return this.delegate.pitch();
        }

        @Override
        public float bodyYaw() {
            return this.delegate.bodyYaw();
        }

        @Override
        public float yaw() {
            return this.delegate.yaw();
        }

        @Override
        public double scale() {
            return this.delegate.scale() * this.scaleMultiplier;
        }

        @Override
        public float damageTick() {
            return this.delegate.damageTick();
        }

        @Override
        public float walkSpeed() {
            return this.delegate.walkSpeed();
        }

        @Override
        public boolean fly() {
            return this.delegate.fly();
        }

        @Override
        @NotNull
        public Vector3f passengerPosition() {
            return this.delegate.passengerPosition().div((float)this.scaleMultiplier);
        }
    }
}

