/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIBukkit;
import kr.toxicity.model.shaded.dev.jorel.commandapi.CommandAPIHandler;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.Argument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.GreedyArgument;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.PreviewInfo;
import kr.toxicity.model.shaded.dev.jorel.commandapi.arguments.Previewable;
import kr.toxicity.model.shaded.dev.jorel.commandapi.commandsenders.BukkitPlayer;
import kr.toxicity.model.shaded.dev.jorel.commandapi.exceptions.SpigotNotFoundException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import kr.toxicity.model.shaded.dev.jorel.commandapi.executors.CommandArguments;
import kr.toxicity.model.shaded.dev.jorel.commandapi.wrappers.PreviewableFunction;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatArgument
extends Argument<BaseComponent[]>
implements GreedyArgument,
Previewable<ChatArgument, BaseComponent[]> {
    private PreviewableFunction<BaseComponent[]> preview;
    private boolean usePreview;

    public ChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException e) {
            throw new SpigotNotFoundException(this.getClass());
        }
    }

    @Override
    public Class<BaseComponent[]> getPrimitiveType() {
        return BaseComponent[].class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CHAT;
    }

    @Override
    public <CommandSourceStack> BaseComponent[] parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        BaseComponent[] component = CommandAPIBukkit.get().getChat(cmdCtx, key);
        Optional<PreviewableFunction<BaseComponent[]>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                BaseComponent[] previewComponent;
                component = previewComponent = previewOptional.get().generatePreview(new PreviewInfo<BaseComponent[]>(new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, key), cmdCtx.getInput(), component));
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    @Override
    public ChatArgument withPreview(PreviewableFunction<BaseComponent[]> preview) {
        this.preview = preview;
        return this;
    }

    @Override
    public Optional<PreviewableFunction<BaseComponent[]>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    @Override
    public boolean isLegacy() {
        return true;
    }

    @Override
    public ChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

