/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.blueprint;

import it.unimi.dsi.fastutil.floats.Float2ObjectMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.FloatAVLTreeSet;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.BlueprintElement;
import kr.toxicity.model.api.util.CollectionUtil;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class AnimationGenerator {
    private static final Vector3f EMPTY = new Vector3f();
    private final Map<BoneName, BlueprintAnimator.AnimatorData> pointMap;
    private final List<AnimationTree> trees;
    private float firstTime = 0.0f;
    private float secondTime = 0.0f;

    @NotNull
    public static Map<BoneName, BlueprintAnimator> createMovements(float length, @NotNull List<BlueprintElement> children, @NotNull Map<BoneName, BlueprintAnimator.AnimatorData> pointMap) {
        FloatAVLTreeSet floatSet = CollectionUtil.mapFloat(pointMap.values().stream().flatMap(BlueprintAnimator.AnimatorData::allPoints), VectorPoint::time, () -> new FloatAVLTreeSet((Comparator)MathUtil.FRAME_COMPARATOR));
        floatSet.add(0.0f);
        floatSet.add(length);
        InterpolationUtil.insertLerpFrame((FloatSortedSet)floatSet);
        AnimationGenerator generator = new AnimationGenerator(pointMap, children);
        generator.interpolateRotation((FloatSortedSet)floatSet);
        generator.interpolateStep((FloatSortedSet)floatSet);
        return CollectionUtil.mapValue(pointMap, v -> new BlueprintAnimator(v.name(), InterpolationUtil.buildAnimation(v.position(), v.rotation(), v.scale(), v.rotationGlobal(), (FloatSortedSet)floatSet)));
    }

    private AnimationGenerator(@NotNull Map<BoneName, BlueprintAnimator.AnimatorData> pointMap, @NotNull List<BlueprintElement> children) {
        this.pointMap = pointMap;
        this.trees = CollectionUtil.filterIsInstance(children, BlueprintElement.Group.class).map(g -> new AnimationTree((BlueprintElement.Group)g, (BlueprintAnimator.AnimatorData)pointMap.get(g.name()))).flatMap(AnimationTree::flatten).toList();
    }

    public void interpolateRotation(@NotNull FloatSortedSet floats) {
        FloatListIterator iterator = new FloatArrayList((FloatCollection)floats).iterator();
        float time = 0.05f;
        while (iterator.hasNext()) {
            double minus;
            float length;
            this.firstTime = this.secondTime;
            this.secondTime = iterator.nextFloat();
            if (this.secondTime - this.firstTime <= 0.0f || (length = (float)Math.ceil((minus = this.trees.stream().mapToDouble(t -> t.tree(this.firstTime, this.secondTime, BlueprintAnimator.AnimatorData::rotation)).max().orElse(0.0)) / 90.0)) < 2.0f) continue;
            float addTime = Math.max(InterpolationUtil.lerp(0.0f, this.secondTime - this.firstTime, 1.0f / length), time);
            for (float f = 1.0f; f < length; f += 1.0f) {
                if (this.secondTime - addTime < time + 0.001f) continue;
                floats.add(this.firstTime + f * addTime);
            }
        }
    }

    public void interpolateStep(@NotNull FloatSortedSet floats) {
        this.trees.stream().map(tree -> tree.data).filter(Objects::nonNull).forEach(data -> {
            this.interpolateStep(floats, data.position());
            this.interpolateStep(floats, data.rotation());
            this.interpolateStep(floats, data.scale());
        });
    }

    private void interpolateStep(@NotNull FloatSortedSet floats, @NotNull List<VectorPoint> points) {
        if (points.size() < 2) {
            return;
        }
        for (int i = 1; i < points.size(); ++i) {
            float time;
            VectorPoint before = points.get(i - 1);
            if (before.isContinuous() || (time = points.get(i).time() - 0.05f) < 0.0f || time - before.time() < 0.0f) continue;
            floats.add(time);
        }
    }

    private class AnimationTree {
        private final AnimationTree parent;
        private final List<AnimationTree> children;
        private final BlueprintAnimator.AnimatorData data;
        private int searchCache = 0;
        private final Float2ObjectMap<Vector3f> valueCache = new Float2ObjectOpenHashMap();

        AnimationTree(@Nullable BlueprintElement.Group group, BlueprintAnimator.AnimatorData data) {
            this(null, group, data);
        }

        AnimationTree(@NotNull AnimationTree parent, @Nullable BlueprintElement.Group group, BlueprintAnimator.AnimatorData data) {
            this.parent = parent;
            this.data = data;
            this.children = CollectionUtil.filterIsInstance(group.children(), BlueprintElement.Group.class).map(g -> new AnimationTree(this, (BlueprintElement.Group)g, AnimationGenerator.this.pointMap.get(g.name()))).toList();
        }

        @NotNull
        Stream<AnimationTree> flatten() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(AnimationTree::flatten));
        }

        private float tree(float first, float second, @NotNull Function<BlueprintAnimator.AnimatorData, List<VectorPoint>> mapper) {
            List<VectorPoint> value = this.data != null ? mapper.apply(this.data) : Collections.emptyList();
            return this.findTree(first, second, value).length();
        }

        @NotNull
        private Vector3f findTree(float first, float second, @NotNull List<VectorPoint> target) {
            Vector3f get = this.find(first, second, target);
            return this.parent != null ? this.parent.findTree(first, second, target).add((Vector3fc)get) : get;
        }

        @NotNull
        private Vector3f find(float first, float second, @NotNull List<VectorPoint> target) {
            return this.find(second, target).sub((Vector3fc)this.find(first, target), new Vector3f());
        }

        @NotNull
        private Vector3f find(float time, @NotNull List<VectorPoint> target) {
            return (Vector3f)this.valueCache.computeIfAbsent(time, f -> {
                int i;
                if (target.size() <= 1) {
                    return EMPTY;
                }
                for (i = this.searchCache; i < target.size() && !(((VectorPoint)target.get(i)).time() >= time); ++i) {
                }
                this.searchCache = i;
                if (i == 0) {
                    return EMPTY;
                }
                if (i == target.size()) {
                    return EMPTY;
                }
                VectorPoint first = (VectorPoint)target.get(i - 1);
                VectorPoint second = (VectorPoint)target.get(i);
                float t1 = first.time();
                float t2 = second.time();
                float a2 = InterpolationUtil.alpha(t1, t2, time);
                return second.time() == time ? second.vector() : InterpolationUtil.lerp(first.vector(InterpolationUtil.lerp(t1, t2, a2)), second.vector(), a2);
            });
        }
    }
}

