/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.blueprint.AnimationMovement;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimation;
import kr.toxicity.model.api.data.blueprint.BlueprintAnimator;
import kr.toxicity.model.api.data.blueprint.NamedBoundingBox;
import kr.toxicity.model.api.data.renderer.AnimationModifier;
import kr.toxicity.model.api.data.renderer.RendererGroup;
import kr.toxicity.model.api.entity.EntityMovement;
import kr.toxicity.model.api.entity.TrackerMovement;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.TransformSupplier;
import kr.toxicity.model.api.player.PlayerLimb;
import kr.toxicity.model.api.tracker.ModelRotation;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class RenderedEntity
implements TransformSupplier,
AutoCloseable {
    private final RendererGroup group;
    private ModelDisplay display;
    private final EntityMovement defaultFrame;
    @Nullable
    private final RenderedEntity parent;
    private Map<String, RenderedEntity> children = Collections.emptyMap();
    private final SequencedMap<String, TreeIterator> animators = new LinkedHashMap<String, TreeIterator>();
    private AnimationMovement keyFrame = null;
    private long delay = 0L;
    private ItemStack itemStack;
    private final List<Consumer<AnimationMovement>> movementModifier = new ArrayList<Consumer<AnimationMovement>>();
    private HitBox hitBox;
    private boolean visible;
    private int tint;
    private TreeIterator currentIterator = null;
    private TrackerMovement lastMovement;
    private EntityMovement lastTransform;
    private Vector3f defaultPosition = new Vector3f();

    public RenderedEntity(@NotNull RendererGroup group, @Nullable RenderedEntity parent, @Nullable ItemStack itemStack, @NotNull ItemDisplay.ItemDisplayTransform transform, @NotNull Location firstLocation, @NotNull EntityMovement movement) {
        this.group = group;
        this.parent = parent;
        this.itemStack = itemStack;
        if (itemStack != null) {
            this.display = BetterModel.inst().nms().create(firstLocation);
            this.display.display(transform);
            if (group.getParent().visibility()) {
                this.display.item(itemStack);
            }
        }
        this.defaultFrame = movement;
        this.visible = group.getLimb() != null || group.getParent().visibility();
    }

    @NotNull
    public ItemStack itemStack() {
        return this.group.getItemStack();
    }

    @ApiStatus.Internal
    public void createHitBox(@NotNull EntityAdapter entity, @NotNull Predicate<RenderedEntity> predicate, @Nullable HitBoxListener listener) {
        NamedBoundingBox h = this.group.getHitBox();
        if (h != null && predicate.test(this)) {
            HitBoxListener l = listener;
            if (this.hitBox != null) {
                this.hitBox.remove();
                if (l == null) {
                    l = this.hitBox.listener();
                }
            }
            this.hitBox = BetterModel.inst().nms().createHitBox(entity, this, h, l != null ? l : HitBoxListener.EMPTY);
        }
        for (RenderedEntity value : this.children.values()) {
            value.createHitBox(entity, predicate, listener);
        }
    }

    @ApiStatus.Internal
    public void itemStack(@NotNull Predicate<RenderedEntity> predicate, @NotNull ItemStack itemStack) {
        if (predicate.test(this)) {
            this.itemStack = itemStack;
            if (this.display != null) {
                this.display.item(itemStack);
            }
        }
        for (RenderedEntity value : this.children.values()) {
            value.itemStack(predicate, itemStack);
        }
    }

    public boolean addAnimationMovementModifier(@NotNull Predicate<RenderedEntity> predicate, @NotNull Consumer<AnimationMovement> consumer) {
        if (predicate.test(this)) {
            this.movementModifier.add(consumer);
            return true;
        }
        boolean ret = false;
        for (RenderedEntity value : this.children.values()) {
            if (!value.addAnimationMovementModifier(predicate, consumer)) continue;
            ret = true;
        }
        return ret;
    }

    @ApiStatus.Internal
    public void renderers(List<RenderedEntity> renderers) {
        renderers.add(this);
        this.children.values().forEach(c -> c.renderers(renderers));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAnimation() {
        SequencedMap<String, TreeIterator> sequencedMap = this.animators;
        synchronized (sequencedMap) {
            Iterator<TreeIterator> iterator2 = this.animators.reversed().values().iterator();
            boolean check = true;
            while (iterator2.hasNext()) {
                TreeIterator next = (TreeIterator)iterator2.next();
                if (!next.get().booleanValue()) continue;
                if (check) {
                    if (this.currentIterator == null) {
                        if (this.updateKeyframe(iterator2, next)) {
                            this.currentIterator = next;
                        }
                    } else if (this.currentIterator != next) {
                        if (this.updateKeyframe(iterator2, next)) {
                            this.currentIterator = next;
                            this.delay = 0L;
                        }
                    } else if (this.delay <= 0L) {
                        this.updateKeyframe(iterator2, next);
                    }
                    check = false;
                    continue;
                }
                next.clear();
            }
            if (check) {
                this.keyFrame = null;
            }
        }
        for (RenderedEntity e : this.children.values()) {
            e.updateAnimation();
        }
    }

    private boolean updateKeyframe(Iterator<TreeIterator> iterator2, TreeIterator next) {
        if (!next.hasNext()) {
            next.run();
            iterator2.remove();
            return false;
        }
        this.keyFrame = next.next();
        return true;
    }

    public void lastMovement(@NotNull TrackerMovement movement) {
        this.lastMovement = movement;
        for (RenderedEntity value : this.children.values()) {
            value.lastMovement(movement);
        }
    }

    public void move(@NotNull ModelRotation rotation, @NotNull TrackerMovement movement, @NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        if (d != null && this.delay % 5L == 0L) {
            d.rotate(rotation, bundler);
        }
        if (this.delay <= 0L) {
            int f = this.frame();
            this.delay = f;
            this.lastMovement = movement.copy();
            this.lastTransform = this.lastMovement.plus(this.relativeOffset());
            EntityMovement entityMovement = this.lastTransform.plus(this.defaultPosition);
            if (d != null) {
                d.frame(f <= 0 ? 0 : (int)Math.ceil((float)f / 5.0f) + 2);
                this.setup(entityMovement);
                d.send(bundler);
            }
        }
        --this.delay;
        for (RenderedEntity e : this.children.values()) {
            e.move(rotation, movement, bundler);
        }
    }

    public void forceUpdate(@NotNull PacketBundler bundler) {
        ModelDisplay d = this.display;
        float speed = this.currentIterator != null ? this.currentIterator.modifier.speedValue() : 1.0f;
        this.delay = Math.round((double)speed * (double)this.delay);
        if (d != null && this.lastMovement != null && this.delay > 0L) {
            this.lastTransform = this.lastMovement.copy().plus(this.relativeOffset());
            EntityMovement entityMovement = this.lastTransform.plus(this.defaultPosition);
            d.frame((int)Math.ceil((float)this.delay / 5.0f) + 2);
            this.setup(entityMovement);
            d.send(bundler);
        }
    }

    @NotNull
    public Vector3f lastTransform() {
        return this.lastTransform != null ? new Vector3f((Vector3fc)this.lastTransform.transform()).add((Vector3fc)this.defaultPosition).mul(this.progress()) : new Vector3f();
    }

    public void setup(@NotNull TrackerMovement movement) {
        this.setup(movement.plus(this.relativeOffset().plus(this.defaultPosition)));
        for (RenderedEntity value : this.children.values()) {
            value.setup(movement);
        }
    }

    private void setup(@NotNull EntityMovement entityMovement) {
        if (this.display != null) {
            PlayerLimb limb = this.group.getLimb();
            this.display.transform(new Transformation(limb != null ? new Vector3f((Vector3fc)entityMovement.transform()).add((Vector3fc)new Vector3f((Vector3fc)limb.getOffset()).rotate((Quaternionfc)entityMovement.rotation())) : entityMovement.transform(), entityMovement.rotation(), new Vector3f((Vector3fc)entityMovement.scale()).mul((Vector3fc)this.group.getScale()), new Quaternionf()));
        }
    }

    public void defaultPosition(@NotNull Vector3f movement) {
        this.defaultPosition = this.group.getLimb() != null ? new Vector3f((Vector3fc)movement).add((Vector3fc)this.group.getLimb().getPosition()) : movement;
        for (RenderedEntity value : this.children.values()) {
            value.defaultPosition(movement);
        }
    }

    private int frame() {
        return this.keyFrame != null ? Math.round(this.keyFrame.time() * 100.0f) : (this.parent != null ? this.parent.frame() : 5);
    }

    private EntityMovement defaultFrame() {
        AnimationMovement k = this.keyFrame != null ? this.keyFrame.copyNotNull() : new AnimationMovement(0.0f, new Vector3f(), new Vector3f(), new Vector3f());
        for (Consumer<AnimationMovement> consumer : this.movementModifier) {
            consumer.accept(k);
        }
        return this.defaultFrame.plus(k);
    }

    private float progress() {
        return (float)this.delay / (float)this.frame();
    }

    private EntityMovement relativeOffset() {
        EntityMovement def = this.defaultFrame();
        if (this.parent != null) {
            EntityMovement p = this.parent.relativeOffset();
            return new EntityMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
        }
        return def;
    }

    private EntityMovement relativeHitBoxOffset() {
        EntityMovement def = this.defaultFrame();
        NamedBoundingBox hitBox = this.group.getHitBox();
        if (hitBox != null) {
            def.transform().add((Vector3fc)hitBox.centerVector());
        }
        if (this.parent != null) {
            EntityMovement p = this.parent.relativeOffset();
            return new EntityMovement(new Vector3f((Vector3fc)p.transform()).add((Vector3fc)new Vector3f((Vector3fc)def.transform()).mul((Vector3fc)p.scale()).rotate((Quaternionfc)p.rotation())), new Vector3f((Vector3fc)def.scale()).mul((Vector3fc)p.scale()), new Quaternionf((Quaternionfc)p.rotation()).mul((Quaternionfc)def.rotation()), def.rawRotation());
        }
        return def;
    }

    public double height() {
        double d = (double)this.defaultPosition.y + (double)(this.lastTransform != null ? new Vector3f((Vector3fc)this.lastTransform.transform()).mul((float)this.progress()).y : 0.0f);
        for (RenderedEntity value : this.children.values()) {
            double v = value.height();
            if (!(this.getGroup().getCenter().y < value.getGroup().getCenter().y)) continue;
            d = v;
        }
        return d;
    }

    public void tint(int toggle, @NotNull PacketBundler bundler) {
        this.tint = toggle;
        if (this.applyItem()) {
            this.forceUpdate(bundler);
        }
        for (RenderedEntity value : this.children.values()) {
            value.tint(toggle, bundler);
        }
    }

    private boolean applyItem() {
        if (this.display != null) {
            this.display.item(this.visible ? BetterModel.inst().nms().tint(this.itemStack.clone(), this.tint) : new ItemStack(Material.AIR));
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        return this.getGroup().getName();
    }

    public void teleport(@NotNull Location location, @NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.teleport(location, bundler);
        }
        this.children.values().forEach(e -> e.teleport(location, bundler));
    }

    public void spawn(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.spawn(bundler);
        }
        this.children.values().forEach(e -> e.spawn(bundler));
    }

    private void applyAnimation() {
        if (this.lastTransform != null) {
            this.setup(this.lastTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.loopIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
            this.applyAnimation();
        }
        this.children.values().forEach(c -> c.addLoop(filter, parent, animator, modifier, () -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent, @NotNull BlueprintAnimation animator, AnimationModifier modifier, Runnable removeTask) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            TreeIterator iterator2 = get != null ? new TreeIterator(parent, get.singleIterator(), modifier, removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), modifier, removeTask);
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.putLast(parent, iterator2);
            }
            this.applyAnimation();
        }
        this.children.values().forEach(c -> c.addSingle(filter, parent, animator, modifier, () -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLoop(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptyLoopIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.loopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}) : new TreeIterator(parent, animator.emptyLoopIterator(), AnimationModifier.DEFAULT_LOOP, () -> {}));
                }
            }
            this.applyAnimation();
        }
        this.children.values().forEach(c -> c.replaceLoop(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSingle(@NotNull Predicate<RenderedEntity> filter, @NotNull String target, @NotNull String parent, @NotNull BlueprintAnimation animator) {
        if (filter.test(this)) {
            BlueprintAnimator get = animator.animator().get(this.getName());
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                TreeIterator v = (TreeIterator)this.animators.get(target);
                if (v != null) {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), v.modifier, v.removeTask) : new TreeIterator(parent, animator.emptySingleIterator(), v.modifier, v.removeTask));
                } else {
                    this.animators.replace(target, get != null ? new TreeIterator(parent, get.singleIterator(), AnimationModifier.DEFAULT, () -> {}) : new TreeIterator(parent, animator.emptySingleIterator(), AnimationModifier.DEFAULT, () -> {}));
                }
            }
            this.applyAnimation();
        }
        this.children.values().forEach(c -> c.replaceSingle(filter, target, parent, animator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull Predicate<RenderedEntity> filter, @NotNull String parent) {
        if (filter.test(this)) {
            SequencedMap<String, TreeIterator> sequencedMap = this.animators;
            synchronized (sequencedMap) {
                this.animators.remove(parent);
            }
        }
        this.children.values().forEach(c -> c.stopAnimation(filter, parent));
    }

    public void remove(@NotNull PacketBundler bundler) {
        if (this.display != null) {
            this.display.remove(bundler);
        }
        this.children.values().forEach(e -> e.remove(bundler));
    }

    public void togglePart(@NotNull PacketBundler bundler, @NotNull Predicate<RenderedEntity> predicate, boolean toggle) {
        if (predicate.test(this)) {
            this.visible = toggle;
            if (this.applyItem()) {
                this.forceUpdate(bundler);
            }
        }
        for (RenderedEntity value : this.children.values()) {
            value.togglePart(bundler, predicate, toggle);
        }
    }

    @Override
    @NotNull
    public Vector3f supplyTransform() {
        return this.lastMovement != null ? this.lastMovement.plus(this.relativeHitBoxOffset().plus(this.defaultPosition)).transform() : this.relativeHitBoxOffset().plus(this.defaultPosition).transform();
    }

    @Override
    public void close() throws Exception {
        if (this.hitBox != null) {
            this.hitBox.remove();
        }
        if (this.display != null) {
            this.display.close();
        }
        for (RenderedEntity value : this.children.values()) {
            value.close();
        }
    }

    @Generated
    public RendererGroup getGroup() {
        return this.group;
    }

    @Generated
    public ModelDisplay getDisplay() {
        return this.display;
    }

    @Generated
    public void setChildren(Map<String, RenderedEntity> children) {
        this.children = children;
    }

    @Generated
    public HitBox getHitBox() {
        return this.hitBox;
    }

    private static class TreeIterator
    implements BlueprintAnimator.AnimatorIterator,
    Supplier<Boolean>,
    Runnable {
        private final String name;
        private final BlueprintAnimator.AnimatorIterator iterator;
        private final AnimationModifier modifier;
        private final Runnable removeTask;
        private boolean started = false;
        private boolean ended = false;

        @Override
        @NotNull
        public AnimationMovement first() {
            return this.iterator.first();
        }

        @Override
        public int index() {
            return this.iterator.index();
        }

        @Override
        public int lastIndex() {
            return this.iterator.lastIndex();
        }

        @Override
        public void run() {
            this.removeTask.run();
        }

        @Override
        public Boolean get() {
            return this.modifier.predicate().get();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext() || this.modifier.end() > 0 && !this.ended;
        }

        @Override
        public AnimationMovement next() {
            if (!this.started) {
                this.started = true;
                return this.first().time((float)this.modifier.start() / 20.0f);
            }
            if (!this.iterator.hasNext()) {
                this.ended = true;
                return new AnimationMovement((float)this.modifier.end() / 20.0f, null, null, null);
            }
            AnimationMovement nxt = (AnimationMovement)this.iterator.next();
            nxt = nxt.time(Math.max(nxt.time() / this.modifier.speedValue(), 0.01f));
            return nxt;
        }

        @Override
        public void clear() {
            this.ended = false;
            this.started = false;
            this.iterator.clear();
        }

        @Override
        public int length() {
            return this.iterator.length();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeIterator that = (TreeIterator)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        @Generated
        public TreeIterator(String name, BlueprintAnimator.AnimatorIterator iterator2, AnimationModifier modifier, Runnable removeTask) {
            this.name = name;
            this.iterator = iterator2;
            this.modifier = modifier;
            this.removeTask = removeTask;
        }
    }
}

