/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatBidirectionalIterator;
import it.unimi.dsi.fastutil.floats.FloatCollection;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import it.unimi.dsi.fastutil.floats.FloatSortedSet;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationMovement;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public final class InterpolationUtil {
    private static final float FRAME_HASH = 0.01f;
    private static final float FRAME_HASH_REVERT = 100.0f;

    private InterpolationUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static @Unmodifiable List<AnimationMovement> buildAnimation(@NotNull List<VectorPoint> position, @NotNull List<VectorPoint> rotation2, @NotNull List<VectorPoint> scale2, @NotNull FloatSortedSet points) {
        VectorPointBuilder pp = InterpolationUtil.interpolatorFor(position);
        VectorPointBuilder sp = InterpolationUtil.interpolatorFor(scale2);
        VectorPointBuilder rp = InterpolationUtil.interpolatorFor(rotation2);
        AnimationMovement[] array = new AnimationMovement[points.size()];
        float before = 0.0f;
        FloatBidirectionalIterator iterator = points.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            float f = iterator.nextFloat();
            array[i++] = new AnimationMovement(InterpolationUtil.roundTime(f - before), FunctionUtil.takeIf(pp.build(f), MathUtil::isNotZero), FunctionUtil.takeIf(sp.build(f), MathUtil::isNotZero), FunctionUtil.takeIf(rp.build(f), MathUtil::isNotZero));
            before = f;
        }
        return List.of(array);
    }

    @NotNull
    public static VectorPointBuilder interpolatorFor(final @NotNull List<VectorPoint> vectors) {
        VectorPoint last;
        VectorPoint vectorPoint = last = vectors.isEmpty() ? VectorPoint.EMPTY : vectors.getLast();
        return vectors.size() < 2 ? last::vector : new VectorPointBuilder(){
            private VectorPoint p1 = VectorPoint.EMPTY;
            private VectorPoint p2 = (VectorPoint)vectors.getFirst();
            private int i = 0;
            private float t = this.p2.time();

            @Override
            @NotNull
            public Vector3f build(float nextFloat) {
                while (this.i < vectors.size() - 1 && this.t < nextFloat) {
                    this.p1 = this.p2;
                    this.p2 = (VectorPoint)vectors.get(++this.i);
                    this.t = this.p2.time();
                }
                if (nextFloat > last.time()) {
                    return last.vector(nextFloat);
                }
                return nextFloat == this.t ? this.p2.vector() : this.p1.interpolator().interpolate(vectors, this.i, nextFloat);
            }
        };
    }

    public static float roundTime(float time) {
        return (float)((int)MathUtil.fma(time, 100.0f, 0.001f)) * 0.01f;
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames) {
        InterpolationUtil.insertLerpFrame(frames, (float)BetterModel.config().lerpFrameTime() / 20.0f);
    }

    public static void insertLerpFrame(@NotNull FloatSortedSet frames, float frame) {
        if (frame <= 0.0f) {
            return;
        }
        float first = 0.0f;
        float second = 0.0f;
        FloatListIterator iterator = new FloatArrayList((FloatCollection)frames).iterator();
        while (iterator.hasNext()) {
            first = second;
            second = iterator.nextFloat();
            int max = (int)((second - first) / frame);
            for (int i = 0; i < max; ++i) {
                float add = MathUtil.fma(frame, (float)(i + 1), first);
                if (second - add < frame + 0.001f) continue;
                frames.add(add);
            }
        }
    }

    public static float alpha(float p0, float p1, float alpha) {
        float div = p1 - p0;
        return div == 0.0f ? 0.0f : (alpha - p0) / div;
    }

    @NotNull
    public static Vector3f lerp(@NotNull Vector3f p0, @NotNull Vector3f p1, float alpha) {
        return new Vector3f(InterpolationUtil.lerp(p0.x, p1.x, alpha), InterpolationUtil.lerp(p0.y, p1.y, alpha), InterpolationUtil.lerp(p0.z, p1.z, alpha));
    }

    public static float lerp(float p0, float p1, float alpha) {
        return MathUtil.fma(p1 - p0, alpha, p0);
    }

    private static float cubicBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float tt = t * t;
        float uuu = uu * u;
        float utt = u * tt;
        float uut = uu * t;
        float ttt = tt * t;
        return MathUtil.fma(uuu, p0, MathUtil.fma(3.0f * uut, p1, MathUtil.fma(3.0f * utt, p2, ttt * p3)));
    }

    private static float derivativeBezier(float p0, float p1, float p2, float p3, float t) {
        float u = 1.0f - t;
        float uu = u * u;
        float ut = u * t;
        float tt = t * t;
        return MathUtil.fma(3.0f * uu, p1 - p0, MathUtil.fma(6.0f * ut, p2 - p1, 3.0f * tt * (p3 - p2)));
    }

    private static float solveBezierTForTime(float time, float t0, float h1, float h2, float t1) {
        float t = 0.5f;
        int maxIterations = 20;
        for (int i = 0; i < maxIterations; ++i) {
            float bezTime = InterpolationUtil.cubicBezier(t0, h1, h2, t1, t);
            float derivative = InterpolationUtil.derivativeBezier(t0, h1, h2, t1, t);
            float error = bezTime - time;
            if (Math.abs(error) < 1.0E-5f) {
                return t;
            }
            if (derivative != 0.0f) {
                t -= error / derivative;
            }
            t = Math.clamp(t, 0.0f, 1.0f);
        }
        return t;
    }

    @NotNull
    public static Vector3f bezier(float time, float startTime, float endTime, @NotNull Vector3f startValue, @NotNull Vector3f endValue, @Nullable Vector3f bezierLeftTime, @Nullable Vector3f bezierLeftValue, @Nullable Vector3f bezierRightTime, @Nullable Vector3f bezierRightValue) {
        Vector3f p1 = bezierRightValue != null ? bezierRightValue.add((Vector3fc)startValue, new Vector3f()) : startValue;
        Vector3f p2 = bezierLeftValue != null ? bezierLeftValue.add((Vector3fc)endValue, new Vector3f()) : endValue;
        return new Vector3f(InterpolationUtil.cubicBezier(startValue.x, p1.x, p2.x, endValue.x, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.x + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.x + endTime : endTime, endTime)), InterpolationUtil.cubicBezier(startValue.y, p1.y, p2.y, endValue.y, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.y + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.y + endTime : endTime, endTime)), InterpolationUtil.cubicBezier(startValue.z, p1.z, p2.z, endValue.z, InterpolationUtil.solveBezierTForTime(time, startTime, bezierRightTime != null ? bezierRightTime.z + startTime : startTime, bezierLeftTime != null ? bezierLeftTime.z + endTime : endTime, endTime)));
    }

    @NotNull
    public static Vector3f catmull_rom(@NotNull Vector3f p0, @NotNull Vector3f p1, @NotNull Vector3f p2, @NotNull Vector3f p3, float t) {
        float t2 = t * t;
        float t3 = t2 * t;
        return new Vector3f(MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.x, MathUtil.fma(3.0f, p1.x, MathUtil.fma(-3.0f, p2.x, p3.x))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.x, MathUtil.fma(-5.0f, p1.x, MathUtil.fma(4.0f, p2.x, -p3.x))), MathUtil.fma(t, -p0.x + p2.x, 2.0f * p1.x))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.y, MathUtil.fma(3.0f, p1.y, MathUtil.fma(-3.0f, p2.y, p3.y))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.y, MathUtil.fma(-5.0f, p1.y, MathUtil.fma(4.0f, p2.y, -p3.y))), MathUtil.fma(t, -p0.y + p2.y, 2.0f * p1.y))), MathUtil.fma(t3, MathUtil.fma(-1.0f, p0.z, MathUtil.fma(3.0f, p1.z, MathUtil.fma(-3.0f, p2.z, p3.z))), MathUtil.fma(t2, MathUtil.fma(2.0f, p0.z, MathUtil.fma(-5.0f, p1.z, MathUtil.fma(4.0f, p2.z, -p3.z))), MathUtil.fma(t, -p0.z + p2.z, 2.0f * p1.z)))).mul(0.5f);
    }

    @FunctionalInterface
    public static interface VectorPointBuilder {
        @NotNull
        public Vector3f build(float var1);
    }
}

