/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import kr.toxicity.model.api.bone.BoneName;
import kr.toxicity.model.api.bone.BoneTagRegistry;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function0;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.util.LengthFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u001a0\u0010\n\u001a\u0004\b\u0002H\u000b\"\u0004\b\u0000\u0010\u000b*\u0004\u0018\u0001H\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010\u000f\u001a\n\u0010\u0010\u001a\u00020\u000e*\u00020\u0011\u001a\n\u0010\u0017\u001a\u00020\u000e*\u00020\u0018\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u001a\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u000b\n\u0005\b\u009920\u0001\n\u0002\b9\u00a8\u0006\u0019"}, d2={"BYTE_UNIT", "Ljava/math/BigDecimal;", "getBYTE_UNIT", "()Ljava/math/BigDecimal;", "COMMA_FORMAT", "Ljava/text/DecimalFormat;", "getCOMMA_FORMAT", "()Ljava/text/DecimalFormat;", "COMMA_DECIMAL_FORMAT", "getCOMMA_DECIMAL_FORMAT", "ifNull", "T", "lazyMessage", "Lkr/toxicity/model/shaded/kotlin/Function0;", "", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "withComma", "", "boneName", "Lkr/toxicity/model/api/bone/BoneName;", "Lorg/jetbrains/annotations/NotNull;", "getBoneName", "(Ljava/lang/String;)Lkr/toxicity/model/api/bone/BoneName;", "toByteFormat", "", "core"})
public final class FunctionsKt {
    @NotNull
    private static final BigDecimal BYTE_UNIT = new BigDecimal("1024.000");
    @NotNull
    private static final DecimalFormat COMMA_FORMAT = new DecimalFormat("#,###");
    @NotNull
    private static final DecimalFormat COMMA_DECIMAL_FORMAT = new DecimalFormat("#,###.000");

    @NotNull
    public static final BigDecimal getBYTE_UNIT() {
        return BYTE_UNIT;
    }

    @NotNull
    public static final DecimalFormat getCOMMA_FORMAT() {
        return COMMA_FORMAT;
    }

    @NotNull
    public static final DecimalFormat getCOMMA_DECIMAL_FORMAT() {
        return COMMA_DECIMAL_FORMAT;
    }

    @NotNull
    public static final <T> T ifNull(@Nullable T $this$ifNull, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$ifNull = false;
        T t = $this$ifNull;
        if (t == null) {
            throw new RuntimeException((String)lazyMessage.invoke());
        }
        return t;
    }

    @NotNull
    public static final String withComma(@NotNull Number $this$withComma) {
        Intrinsics.checkNotNullParameter((Object)$this$withComma, (String)"<this>");
        String string = COMMA_FORMAT.format($this$withComma);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final BoneName getBoneName(@NotNull String $this$boneName) {
        Intrinsics.checkNotNullParameter((Object)$this$boneName, (String)"<this>");
        BoneName boneName = BoneTagRegistry.parse($this$boneName);
        Intrinsics.checkNotNullExpressionValue((Object)boneName, (String)"parse(...)");
        return boneName;
    }

    @NotNull
    public static final String toByteFormat(long $this$toByteFormat) {
        BigDecimal value = new BigDecimal($this$toByteFormat + ".000");
        for (LengthFormat format : LengthFormat.getEntries()) {
            if (value.compareTo(BYTE_UNIT) < 0) {
                return COMMA_DECIMAL_FORMAT.format(value) + " " + format.name();
            }
            Intrinsics.checkNotNullExpressionValue((Object)value.divide(BYTE_UNIT, RoundingMode.HALF_EVEN), (String)"divide(...)");
        }
        return COMMA_DECIMAL_FORMAT.format(value) + " " + ((LengthFormat)((Object)CollectionsKt.last((List)((List)LengthFormat.getEntries())))).name();
    }
}

