/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.player;

import java.util.function.BiFunction;
import java.util.function.Function;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.armor.PlayerArmor;
import kr.toxicity.model.api.bone.BoneItemMapper;
import kr.toxicity.model.api.bone.BoneRenderContext;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.nms.Profiled;
import kr.toxicity.model.api.profile.ModelProfile;
import kr.toxicity.model.api.skin.SkinData;
import kr.toxicity.model.api.util.TransformedItemStack;
import lombok.Generated;
import org.bukkit.entity.ItemDisplay;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public enum PlayerLimb {
    HEAD(PlayerLimb.position(0), PlayerLimb.scale(7.4688f, 0.5f), PlayerLimb.scale(7.4688f, 0.5f), PlayerLimb.offset(0.0f, 7.5f, 0.0f, 0.5f), PlayerLimb.offset(0.0f, 7.5f, 0.0f, 0.5f), SkinData::head, ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_ARM(PlayerLimb.position(1), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(-0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(-0.043f, 1.5f, 0.0f, 0.25f), SkinData::rightArm, ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_FOREARM(PlayerLimb.position(2), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(-0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(-0.043f, 1.5f, 0.0f, 0.25f), (d2, p) -> d2.rightForeArm(), ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_ARM(PlayerLimb.position(3), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(0.043f, 1.5f, 0.0f, 0.25f), SkinData::leftArm, ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_FOREARM(PlayerLimb.position(4), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(2.7891f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.625f, 1.5f, 0.0f, 0.25f), PlayerLimb.offset(0.043f, 1.5f, 0.0f, 0.25f), (d2, p) -> d2.leftForeArm(), ItemDisplay.ItemDisplayTransform.FIXED),
    HIP(PlayerLimb.position(5), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), SkinData::hip, ItemDisplay.ItemDisplayTransform.FIXED),
    WAIST(PlayerLimb.position(6), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), SkinData::waist, ItemDisplay.ItemDisplayTransform.FIXED),
    CHEST(PlayerLimb.position(7), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.scale(7.4688f, 3.7188f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 5.75f, 0.0f, 0.25f), SkinData::chest, ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_LEG(PlayerLimb.position(8), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), SkinData::rightLeg, ItemDisplay.ItemDisplayTransform.FIXED),
    RIGHT_FORELEG(PlayerLimb.position(9), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), SkinData::rightForeLeg, ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_LEG(PlayerLimb.position(10), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), SkinData::leftLeg, ItemDisplay.ItemDisplayTransform.FIXED),
    LEFT_FORELEG(PlayerLimb.position(11), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.scale(3.7188f, 5.5938f, 3.7188f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), PlayerLimb.offset(0.0f, 1.12f, 0.0f, 0.25f), SkinData::leftForeLeg, ItemDisplay.ItemDisplayTransform.FIXED);

    @NotNull
    private final Vector3f position;
    @NotNull
    private final Vector3f scale;
    @NotNull
    private final Vector3f slimScale;
    @NotNull
    private final Vector3f offset;
    @NotNull
    private final Vector3f slimOffset;
    @NotNull
    private final BiFunction<SkinData, PlayerArmor, TransformedItemStack> skinMapper;
    @NotNull
    private final ItemDisplay.ItemDisplayTransform transform;
    @NotNull
    private final LimbItemMapper itemMapper = new LimbItemMapper(this::createItem);

    @NotNull
    private static Vector3f position(int mul) {
        return new Vector3f(0.0f, -512.0f, 0.0f).mul((float)mul);
    }

    @NotNull
    private static Vector3f scale(float scale2, float inflate) {
        return PlayerLimb.scale(scale2, scale2, scale2, inflate);
    }

    @NotNull
    private static Vector3f scale(float x, float y, float z, float inflate) {
        return new Vector3f(x, y, z).div(8.0f).add((Vector3fc)new Vector3f(inflate).div(8.0f));
    }

    @NotNull
    private static Vector3f offset(float x, float y, float z, float inflate) {
        return new Vector3f(0.0f, -0.25f, 0.0f).add((Vector3fc)new Vector3f(x, y, z).div(16.0f)).add((Vector3fc)new Vector3f(0.0f, inflate, 0.0f).div(32.0f));
    }

    @NotNull
    public TransformedItemStack createItem(@NotNull BoneRenderContext context) {
        if (BetterModel.plugin().skinManager().supported()) {
            PlayerArmor playerArmor;
            SkinData skinData = context.skin();
            RenderSource<?> renderSource = context.source();
            if (renderSource instanceof Profiled) {
                Profiled profiled = (Profiled)((Object)renderSource);
                playerArmor = profiled.armors();
            } else {
                playerArmor = PlayerArmor.EMPTY;
            }
            return this.skinMapper.apply(skinData, playerArmor);
        }
        ModelProfile profile = context.skin().profile();
        boolean isSlim = profile.skin().slim();
        return TransformedItemStack.of(this.position, isSlim ? this.slimOffset : this.offset, isSlim ? this.slimScale : this.scale, BetterModel.nms().createPlayerHead(profile));
    }

    @Generated
    private PlayerLimb(@NotNull Vector3f position, @NotNull Vector3f scale2, @NotNull Vector3f slimScale, @NotNull Vector3f offset, @NotNull Vector3f slimOffset, BiFunction<SkinData, PlayerArmor, TransformedItemStack> skinMapper, ItemDisplay.ItemDisplayTransform transform) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (scale2 == null) {
            throw new NullPointerException("scale is marked non-null but is null");
        }
        if (slimScale == null) {
            throw new NullPointerException("slimScale is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        if (slimOffset == null) {
            throw new NullPointerException("slimOffset is marked non-null but is null");
        }
        if (skinMapper == null) {
            throw new NullPointerException("skinMapper is marked non-null but is null");
        }
        if (transform == null) {
            throw new NullPointerException("transform is marked non-null but is null");
        }
        this.position = position;
        this.scale = scale2;
        this.slimScale = slimScale;
        this.offset = offset;
        this.slimOffset = slimOffset;
        this.skinMapper = skinMapper;
        this.transform = transform;
    }

    @NotNull
    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @NotNull
    @Generated
    public Vector3f getScale() {
        return this.scale;
    }

    @NotNull
    @Generated
    public Vector3f getSlimScale() {
        return this.slimScale;
    }

    @NotNull
    @Generated
    public Vector3f getOffset() {
        return this.offset;
    }

    @NotNull
    @Generated
    public Vector3f getSlimOffset() {
        return this.slimOffset;
    }

    @NotNull
    @Generated
    public BiFunction<SkinData, PlayerArmor, TransformedItemStack> getSkinMapper() {
        return this.skinMapper;
    }

    @NotNull
    @Generated
    public ItemDisplay.ItemDisplayTransform getTransform() {
        return this.transform;
    }

    @NotNull
    @Generated
    public LimbItemMapper getItemMapper() {
        return this.itemMapper;
    }

    public class LimbItemMapper
    implements BoneItemMapper {
        private final Function<BoneRenderContext, TransformedItemStack> playerMapper;

        @Override
        @NotNull
        public ItemDisplay.ItemDisplayTransform transform() {
            return PlayerLimb.this.transform;
        }

        @Override
        @NotNull
        public TransformedItemStack apply(@NotNull BoneRenderContext context, @NotNull TransformedItemStack transformedItemStack) {
            return this.playerMapper.apply(context);
        }

        @Generated
        public LimbItemMapper(Function<BoneRenderContext, TransformedItemStack> playerMapper) {
            this.playerMapper = playerMapper;
        }
    }
}

