/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.shaded.org.incendo.cloud.paper;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.List;
import java.util.logging.Level;
import kr.toxicity.model.shaded.org.incendo.cloud.CloudCapability;
import kr.toxicity.model.shaded.org.incendo.cloud.CommandManager;
import kr.toxicity.model.shaded.org.incendo.cloud.SenderMapper;
import kr.toxicity.model.shaded.org.incendo.cloud.SenderMapperHolder;
import kr.toxicity.model.shaded.org.incendo.cloud.brigadier.BrigadierManagerHolder;
import kr.toxicity.model.shaded.org.incendo.cloud.brigadier.CloudBrigadierManager;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitCommandContextKeys;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitDefaultCaptionsProvider;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.BukkitParsers;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.PluginHolder;
import kr.toxicity.model.shaded.org.incendo.cloud.bukkit.internal.BukkitHelper;
import kr.toxicity.model.shaded.org.incendo.cloud.caption.Caption;
import kr.toxicity.model.shaded.org.incendo.cloud.context.CommandContext;
import kr.toxicity.model.shaded.org.incendo.cloud.execution.ExecutionCoordinator;
import kr.toxicity.model.shaded.org.incendo.cloud.internal.CommandRegistrationHandler;
import kr.toxicity.model.shaded.org.incendo.cloud.paper.ModernPaperBrigadier;
import kr.toxicity.model.shaded.org.incendo.cloud.paper.PaperCommandPreprocessor;
import kr.toxicity.model.shaded.org.incendo.cloud.paper.PluginMetaHolder;
import kr.toxicity.model.shaded.org.incendo.cloud.paper.parser.KeyedWorldParser;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apiguardian.api.API;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.EXPERIMENTAL)
public class PaperCommandManager<C>
extends CommandManager<C>
implements SenderMapperHolder<CommandSourceStack, C>,
PluginMetaHolder,
PluginHolder,
BrigadierManagerHolder<C, CommandSourceStack> {
    private final PluginMeta pluginMeta;
    private final SenderMapper<CommandSourceStack, C> senderMapper;

    public static <C> Builder<C> builder(SenderMapper<CommandSourceStack, C> senderMapper) {
        return new Builder(senderMapper);
    }

    public static Builder<CommandSourceStack> builder() {
        return new Builder<CommandSourceStack>(SenderMapper.identity());
    }

    private PaperCommandManager(@NonNull PluginMeta pluginMeta, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<CommandSourceStack, C> senderMapper) {
        super(executionCoordinator, CommandRegistrationHandler.nullCommandRegistrationHandler());
        this.pluginMeta = pluginMeta;
        this.senderMapper = senderMapper;
        this.commandRegistrationHandler(new ModernPaperBrigadier<C, CommandSourceStack>(CommandSourceStack.class, this, senderMapper, () -> this.lockRegistration()));
        CloudBukkitCapabilities.CAPABLE.forEach(x$0 -> this.registerCapability((CloudCapability)x$0));
        this.registerCapability((CloudCapability)CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
        BukkitParsers.register(this);
        this.registerDefaultExceptionHandlers();
        this.captionRegistry().registerProvider(new BukkitDefaultCaptionsProvider());
        this.registerCommandPreProcessor(ctx -> ctx.commandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, (Object)((CommandSourceStack)this.senderMapper().reverse(ctx.commandContext().sender())).getSender()));
        this.registerCommandPreProcessor(new PaperCommandPreprocessor<CommandSourceStack, C>(this, this.senderMapper(), commandSourceStack -> {
            @Nullable Entity executor = commandSourceStack.getExecutor();
            if (executor != null) {
                return executor;
            }
            return commandSourceStack.getSender();
        }));
        this.parserRegistry().registerParser(KeyedWorldParser.keyedWorldParser());
    }

    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return ((CommandSourceStack)this.senderMapper().reverse(sender)).getSender().hasPermission(permission);
    }

    public final @NonNull SenderMapper<CommandSourceStack, C> senderMapper() {
        return this.senderMapper;
    }

    private void registerDefaultExceptionHandlers() {
        this.registerDefaultExceptionHandlers(triplet -> ((CommandSourceStack)this.senderMapper().reverse(((CommandContext)triplet.first()).sender())).getSender().sendMessage((Component)Component.text((String)((CommandContext)triplet.first()).formatCaption((Caption)triplet.second(), (List)triplet.third()), (TextColor)NamedTextColor.RED)), pair -> this.owningPlugin().getLogger().log(Level.SEVERE, (String)pair.first(), (Throwable)pair.second()));
    }

    @Override
    public final PluginMeta owningPluginMeta() {
        return this.pluginMeta;
    }

    @Override
    public final boolean hasBrigadierManager() {
        return true;
    }

    @Override
    public final @NonNull CloudBrigadierManager<C, ? extends CommandSourceStack> brigadierManager() {
        return ((BrigadierManagerHolder)this.commandRegistrationHandler()).brigadierManager();
    }

    public static final class Builder<C> {
        private final SenderMapper<CommandSourceStack, C> senderMapper;

        private Builder(SenderMapper<CommandSourceStack, C> senderMapper) {
            this.senderMapper = senderMapper;
        }

        public CoordinatedBuilder<C> executionCoordinator(ExecutionCoordinator<C> executionCoordinator) {
            return new CoordinatedBuilder(this.senderMapper, executionCoordinator);
        }
    }

    public static final class CoordinatedBuilder<C> {
        private final SenderMapper<CommandSourceStack, C> senderMapper;
        private final ExecutionCoordinator<C> executionCoordinator;

        private CoordinatedBuilder(SenderMapper<CommandSourceStack, C> senderMapper, ExecutionCoordinator<C> executionCoordinator) {
            this.senderMapper = senderMapper;
            this.executionCoordinator = executionCoordinator;
        }

        public @NonNull PaperCommandManager<C> buildOnEnable(@NonNull Plugin plugin) {
            PaperCommandManager mgr = new PaperCommandManager(plugin.getPluginMeta(), this.executionCoordinator, this.senderMapper);
            ((ModernPaperBrigadier)mgr.commandRegistrationHandler()).registerPlugin(plugin);
            BukkitHelper.ensurePluginEnabledOrEnabling(plugin);
            return mgr;
        }

        public @NonNull Bootstrapped<C> buildBootstrapped(@NonNull BootstrapContext context) {
            Bootstrapped mgr = new Bootstrapped(context.getPluginMeta(), this.executionCoordinator, this.senderMapper);
            ((ModernPaperBrigadier)mgr.commandRegistrationHandler()).registerBootstrap(context);
            return mgr;
        }
    }

    public static final class Bootstrapped<C>
    extends PaperCommandManager<C> {
        private Bootstrapped(@NonNull PluginMeta pluginMeta, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<CommandSourceStack, C> senderMapper) {
            super(pluginMeta, executionCoordinator, senderMapper);
        }

        public void onEnable() {
            BukkitHelper.ensurePluginEnabledOrEnabling(this.owningPlugin());
        }
    }
}

