/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.animation;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kr.toxicity.model.api.animation.AnimationMovement;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public interface AnimationIterator
extends Iterator<AnimationMovement> {
    public void clear();

    public int index();

    public int lastIndex();

    @NotNull
    public Type type();

    public static final class Loop
    implements AnimationIterator {
        private final List<AnimationMovement> keyFrame;
        private int index = 0;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public AnimationMovement next() {
            if (this.index >= this.keyFrame.size()) {
                this.index = 0;
            }
            return this.keyFrame.get(this.index++);
        }

        @Override
        @NotNull
        public Type type() {
            return Type.LOOP;
        }

        @Generated
        private Loop(List<AnimationMovement> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static final class HoldOnLast
    implements AnimationIterator {
        private final List<AnimationMovement> keyFrame;
        private int index = 0;
        private boolean finished = false;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = 0;
            this.finished = false;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        @NotNull
        public AnimationMovement next() {
            if (this.finished) {
                AnimationMovement last = this.keyFrame.getLast();
                return new AnimationMovement(0.0f, last.transform(), last.scale(), last.rotation());
            }
            AnimationMovement nextFrame = this.keyFrame.get(this.index++);
            if (this.index >= this.keyFrame.size()) {
                this.finished = true;
            }
            return nextFrame;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.HOLD_ON_LAST;
        }

        @Generated
        private HoldOnLast(List<AnimationMovement> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static final class PlayOnce
    implements AnimationIterator {
        private final List<AnimationMovement> keyFrame;
        private int index = 0;

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public int lastIndex() {
            return this.keyFrame.size() - 1;
        }

        @Override
        public void clear() {
            this.index = Integer.MAX_VALUE;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.keyFrame.size();
        }

        @Override
        @NotNull
        public AnimationMovement next() {
            return this.keyFrame.get(this.index++);
        }

        @Override
        @NotNull
        public Type type() {
            return Type.PLAY_ONCE;
        }

        @Generated
        private PlayOnce(List<AnimationMovement> keyFrame) {
            this.keyFrame = keyFrame;
        }
    }

    public static enum Type {
        PLAY_ONCE(PlayOnce::new),
        LOOP(Loop::new),
        HOLD_ON_LAST(HoldOnLast::new);

        public static final JsonDeserializer<Type> DESERIALIZER;
        private final Function<List<AnimationMovement>, AnimationIterator> mapper;

        @NotNull
        public AnimationIterator create(@NotNull List<AnimationMovement> keyFrames) {
            return this.mapper.apply(keyFrames);
        }

        @Generated
        private Type(Function<List<AnimationMovement>, AnimationIterator> mapper) {
            this.mapper = mapper;
        }

        static {
            DESERIALIZER = new JsonDeserializer<Type>(){

                public Type deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    if (json.isJsonPrimitive()) {
                        return switch (json.getAsString()) {
                            case "loop" -> LOOP;
                            case "hold" -> HOLD_ON_LAST;
                            default -> PLAY_ONCE;
                        };
                    }
                    return PLAY_ONCE;
                }
            };
        }
    }
}

