/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.KeyframeChannel;
import kr.toxicity.model.api.util.interpolation.BezierInterpolation;
import kr.toxicity.model.api.util.interpolation.CatmullRomInterpolation;
import kr.toxicity.model.api.util.interpolation.LinearInterpolation;
import kr.toxicity.model.api.util.interpolation.StepInterpolation;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@ApiStatus.Internal
public record ModelKeyframe(@NotNull KeyframeChannel channel, @SerializedName(value="data_points") @NotNull List<Datapoint> dataPoints, @SerializedName(value="bezier_left_time") @Nullable Float3 bezierLeftTime, @SerializedName(value="bezier_left_value") @Nullable Float3 bezierLeftValue, @SerializedName(value="bezier_right_time") @Nullable Float3 bezierRightTime, @SerializedName(value="bezier_right_value") @Nullable Float3 bezierRightValue, @Nullable String interpolation, float time) implements Comparable<ModelKeyframe>
{
    @NotNull
    public VectorInterpolation findInterpolation() {
        if (this.interpolation == null) {
            return VectorInterpolation.defaultInterpolation();
        }
        return switch (this.interpolation.toLowerCase()) {
            case "linear" -> LinearInterpolation.INSTANCE;
            case "catmullrom" -> CatmullRomInterpolation.INSTANCE;
            case "step" -> StepInterpolation.INSTANCE;
            case "bezier" -> new BezierInterpolation(ModelKeyframe.toBezier(this.bezierLeftTime), ModelKeyframe.toBezier(this.bezierLeftValue), ModelKeyframe.toBezier(this.bezierRightTime), ModelKeyframe.toBezier(this.bezierRightValue));
            default -> VectorInterpolation.defaultInterpolation();
        };
    }

    @Nullable
    private static Vector3f toBezier(@Nullable Float3 float3) {
        return float3 != null ? float3.toVector() : null;
    }

    @NotNull
    public ModelKeyframe time(float time) {
        return new ModelKeyframe(this.channel, this.dataPoints, this.bezierLeftTime, this.bezierLeftValue, this.bezierRightTime, this.bezierRightValue, this.interpolation, time);
    }

    @Override
    public int compareTo(@NotNull ModelKeyframe o) {
        return Float.compare(this.time, o.time);
    }
}

