/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackAssets;
import kr.toxicity.model.api.pack.PackConfig;
import kr.toxicity.model.api.pack.PackMeta;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import kr.toxicity.model.api.util.LogUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackZipper {
    private static final PackPath OVERLAY_LEGACY = new PackPath("bettermodel_legacy");
    private static final PackPath OVERLAY_MODERN = new PackPath("bettermodel_modern");
    private static final PackPath PACK_ICON = new PackPath("pack.png");
    private static final PackMeta.VersionRange LEGACY_FORMATS = new PackMeta.VersionRange(22, 45);
    private static final PackMeta.VersionRange MODERN_FORMATS = new PackMeta.VersionRange(46, 99);
    private final PackMeta.Builder metaBuilder = PackMeta.builder();
    private final PackAssets assets = new PackAssets(PackPath.EMPTY);
    private final PackAssets legacy = new PackAssets(OVERLAY_LEGACY);
    private final PackAssets modern = new PackAssets(OVERLAY_MODERN);

    @NotNull
    public static PackZipper zipper() {
        return new PackZipper();
    }

    @NotNull
    public PackAssets assets() {
        return this.assets;
    }

    @NotNull
    public PackAssets legacy() {
        return this.legacy;
    }

    @NotNull
    public PackAssets modern() {
        return this.modern;
    }

    @NotNull
    public PackMeta.Builder metaBuilder() {
        return this.metaBuilder;
    }

    @NotNull
    public List<PackResource> build() {
        PackConfig config = BetterModel.config().pack();
        ArrayList<PackResource> resources = new ArrayList<PackResource>(this.assets.size() + this.legacy.size() + this.modern.size() + 2);
        resources.addAll(this.assets.resourceMap.values());
        if (config.generateLegacyModel() && this.legacy.dirty()) {
            resources.addAll(this.legacy.resourceMap.values());
            this.metaBuilder.overlayEntry(new PackMeta.OverlayEntry(LEGACY_FORMATS, OVERLAY_LEGACY.path()));
        }
        if (config.generateModernModel() && this.modern.dirty()) {
            resources.addAll(this.modern.resourceMap.values());
            this.metaBuilder.overlayEntry(new PackMeta.OverlayEntry(MODERN_FORMATS, OVERLAY_MODERN.path()));
        }
        resources.add(this.metaBuilder.build().toResource());
        PackResource icon = PackZipper.loadIcon();
        if (icon != null) {
            resources.add(icon);
        }
        this.assets.resourceMap.clear();
        this.legacy.resourceMap.clear();
        this.modern.resourceMap.clear();
        return resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static PackResource loadIcon() {
        try (InputStream icon = BetterModel.plugin().getResource("icon.png");){
            if (icon == null) {
                PackResource packResource2 = null;
                return packResource2;
            }
            byte[] read = icon.readAllBytes();
            PackResource packResource = PackResource.of(PACK_ICON, () -> read);
            return packResource;
        }
        catch (IOException e) {
            LogUtil.handleException("Unable to get icon.png", e);
            return null;
        }
    }

    @Generated
    private PackZipper() {
    }
}

