/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util.interpolation;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.InterpolationUtil;
import kr.toxicity.model.api.util.interpolation.VectorInterpolation;
import org.jetbrains.annotations.NotNull;

public enum CatmullRomInterpolation implements VectorInterpolation
{
    INSTANCE;


    @NotNull
    private static VectorPoint indexOf(@NotNull List<VectorPoint> list, int index, int relative) {
        int i;
        for (i = index + relative; i < 0; i += list.size()) {
        }
        return list.get(i % list.size());
    }

    @Override
    @NotNull
    public VectorPoint interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
        VectorPoint p0 = CatmullRomInterpolation.indexOf(points, p2Index, -2);
        VectorPoint p1 = CatmullRomInterpolation.indexOf(points, p2Index, -1);
        VectorPoint p2 = points.get(p2Index);
        VectorPoint next = CatmullRomInterpolation.indexOf(points, p2Index, 1);
        VectorPoint p3 = next.time() == 0.0f ? CatmullRomInterpolation.indexOf(points, p2Index, 2) : next;
        return new VectorPoint(InterpolationUtil.catmull_rom(p0.vector(), p1.vector(), p2.vector(), p3.vector(), InterpolationUtil.alpha(p1.time(), p2.time(), time)), time, this);
    }
}

