/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class FunctionUtil {
    private FunctionUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static <T> Supplier<T> memoizeTick(@NotNull Supplier<T> supplier) {
        TickMemoizedSupplier<T> tickMemoizedSupplier;
        if (supplier instanceof TickMemoizedSupplier) {
            TickMemoizedSupplier memoizedSupplier = (TickMemoizedSupplier)supplier;
            tickMemoizedSupplier = memoizedSupplier;
        } else {
            tickMemoizedSupplier = new TickMemoizedSupplier<T>(supplier);
        }
        return tickMemoizedSupplier;
    }

    @NotNull
    public static <T> Predicate<T> memoizeTick(@NotNull Predicate<T> predicate) {
        TickMemoizedPredicate<T> tickMemoizedPredicate;
        if (predicate instanceof TickMemoizedPredicate) {
            TickMemoizedPredicate memoizedSupplier = (TickMemoizedPredicate)predicate;
            tickMemoizedPredicate = memoizedSupplier;
        } else {
            tickMemoizedPredicate = new TickMemoizedPredicate<T>(predicate);
        }
        return tickMemoizedPredicate;
    }

    @NotNull
    public static <T, R> Function<T, R> memoizeTick(@NotNull Function<T, R> function) {
        TickMemoizedFunction<T, R> tickMemoizedFunction;
        if (function instanceof TickMemoizedFunction) {
            TickMemoizedFunction memoizedFunction = (TickMemoizedFunction)function;
            tickMemoizedFunction = memoizedFunction;
        } else {
            tickMemoizedFunction = new TickMemoizedFunction<T, R>(function);
        }
        return tickMemoizedFunction;
    }

    private static class TickMemoizedSupplier<T>
    implements Supplier<T> {
        @NotNull
        private final Supplier<T> delegate;
        private volatile long time;
        private volatile T cache;

        @Override
        public synchronized T get() {
            long current = System.currentTimeMillis();
            if (current - this.time >= 50L) {
                this.time = current;
                this.cache = this.delegate.get();
            }
            return this.cache;
        }

        @Generated
        public TickMemoizedSupplier(@NotNull Supplier<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickMemoizedPredicate<T>
    implements Predicate<T> {
        @NotNull
        private final Predicate<T> delegate;
        private volatile long time;
        private volatile boolean cache;

        @Override
        public synchronized boolean test(T t) {
            long current = System.currentTimeMillis();
            if (current - this.time >= 50L) {
                this.time = current;
                this.cache = this.delegate.test(t);
            }
            return this.cache;
        }

        @Generated
        public TickMemoizedPredicate(@NotNull Predicate<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickMemoizedFunction<T, R>
    implements Function<T, R> {
        @NotNull
        private final Function<T, R> delegate;
        private volatile long time;
        private volatile R cache;

        @Override
        public synchronized R apply(T t) {
            long current = System.currentTimeMillis();
            if (current - this.time >= 50L) {
                this.time = current;
                this.cache = this.delegate.apply(t);
            }
            return this.cache;
        }

        @Generated
        public TickMemoizedFunction(@NotNull Function<T, R> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }
}

