/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.raw;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.List;
import kr.toxicity.model.api.data.raw.Datapoint;
import kr.toxicity.model.api.data.raw.Float3;
import kr.toxicity.model.api.data.raw.Float4;
import kr.toxicity.model.api.data.raw.ModelAnimation;
import kr.toxicity.model.api.data.raw.ModelChildren;
import kr.toxicity.model.api.data.raw.ModelElement;
import kr.toxicity.model.api.data.raw.ModelResolution;
import kr.toxicity.model.api.data.raw.ModelTexture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record ModelData(@NotNull ModelResolution resolution, @NotNull List<ModelElement> elements, @NotNull List<ModelChildren> outliner, @NotNull List<ModelTexture> textures, @Nullable List<ModelAnimation> animations) {
    @Nullable
    private final List<ModelAnimation> animations;
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Float3.class, (Object)Float3.PARSER).registerTypeAdapter(Float4.class, (Object)Float4.PARSER).registerTypeAdapter(Datapoint.class, (Object)Datapoint.PARSER).registerTypeAdapter(ModelChildren.class, (Object)ModelChildren.PARSER).create();

    public float scale() {
        return (float)this.elements().stream().mapToDouble(ModelElement::max).max().orElse(16.0) / 16.0f;
    }

    @NotNull
    public List<ModelAnimation> animations() {
        return this.animations != null ? this.animations : Collections.emptyList();
    }
}

