/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.pack.PackPath;
import kr.toxicity.model.api.pack.PackResource;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PackMeta(@NotNull Pack pack, @Nullable Overlay overlays) {
    public static final PackPath PATH = new PackPath("pack.mcmeta");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(VersionRange.class, (json, typeOfT, context) -> {
        if (json.isJsonPrimitive()) {
            return new VersionRange(json.getAsInt());
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            return new VersionRange(array.get(0).getAsInt(), array.get(1).getAsInt());
        }
        if (json.isJsonObject()) {
            return (VersionRange)context.deserialize(json, VersionRange.class);
        }
        return null;
    }).registerTypeAdapter(VersionRange.class, (src, typeOfSrc, context) -> src.toJson()).create();

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public JsonElement toJson() {
        return GSON.toJsonTree((Object)this);
    }

    @NotNull
    public PackResource toResource() {
        return PackResource.of(PATH, () -> GSON.toJson((Object)this).getBytes(StandardCharsets.UTF_8));
    }

    public record Pack(@SerializedName(value="pack_format") int packFormat, @SerializedName(value="description") @NotNull String description) {
    }

    public record Overlay(@Nullable List<OverlayEntry> entries) {
    }

    public static final class Builder {
        private int format = BetterModel.plugin().nms().version().getMetaVersion();
        private String description = "BetterModel's default pack.";
        private final List<OverlayEntry> entries = new ArrayList<OverlayEntry>();

        @NotNull
        public Builder description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @NotNull
        public Builder format(int format) {
            this.format = format;
            return this;
        }

        @NotNull
        public Builder overlayEntry(@NotNull OverlayEntry overlayEntry) {
            this.entries.add(overlayEntry);
            return this;
        }

        @NotNull
        public PackMeta build() {
            return new PackMeta(new Pack(this.format, this.description), this.entries.isEmpty() ? null : new Overlay(this.entries));
        }

        @Generated
        private Builder() {
        }
    }

    public record VersionRange(@SerializedName(value="min_inclusive") int minInclusive, @SerializedName(value="max_inclusive") int maxInclusive) {
        public VersionRange(int value) {
            this(value, value);
        }

        @NotNull
        public JsonElement toJson() {
            if (this.minInclusive == this.maxInclusive) {
                return new JsonPrimitive((Number)this.minInclusive);
            }
            JsonArray arr = new JsonArray(2);
            arr.add((Number)this.minInclusive);
            arr.add((Number)this.maxInclusive);
            return arr;
        }
    }

    public record OverlayEntry(@NotNull VersionRange formats, @NotNull String directory) {
    }
}

