/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.BiPredicate;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.util.TransformedItemStack;
import kr.toxicity.model.api.util.function.BonePredicate;
import lombok.Generated;
import org.bukkit.entity.Display;
import org.jetbrains.annotations.NotNull;

public sealed interface TrackerUpdateAction
extends BiPredicate<RenderedBone, BonePredicate> {
    @Override
    public boolean test(@NotNull RenderedBone var1, @NotNull BonePredicate var2);

    @NotNull
    public static Brightness brightness(int block, int sky) {
        return new Brightness(block, sky);
    }

    @NotNull
    public static Glow glow(boolean glow) {
        return glow ? Glow.TRUE : Glow.FALSE;
    }

    @NotNull
    public static GlowColor glowColor(int glowColor) {
        return new GlowColor(glowColor);
    }

    @NotNull
    public static Tint tint(int rgb) {
        return new Tint(rgb);
    }

    @NotNull
    public static Enchant enchant(boolean enchant) {
        return enchant ? Enchant.TRUE : Enchant.FALSE;
    }

    @NotNull
    public static TogglePart togglePart(boolean toggle) {
        return toggle ? TogglePart.TRUE : TogglePart.FALSE;
    }

    @NotNull
    public static ItemStack itemStack(@NotNull TransformedItemStack itemStack) {
        Objects.requireNonNull(itemStack);
        return new ItemStack(itemStack);
    }

    @NotNull
    public static Billboard billboard(@NotNull Display.Billboard billboard) {
        Objects.requireNonNull(billboard);
        return new Billboard(billboard);
    }

    public record Brightness(int block, int sky) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.brightness(predicate, this.block, this.sky);
        }
    }

    public static enum Glow implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.glow(predicate, this.value);
        }

        @Generated
        private Glow(boolean value) {
            this.value = value;
        }
    }

    public record GlowColor(int glowColor) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.glowColor(predicate, this.glowColor);
        }
    }

    public record Tint(int rgb) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.tint(predicate, this.rgb);
        }
    }

    public static enum Enchant implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.enchant(predicate, this.value);
        }

        @Generated
        private Enchant(boolean value) {
            this.value = value;
        }
    }

    public static enum TogglePart implements TrackerUpdateAction
    {
        TRUE(true),
        FALSE(false);

        private final boolean value;

        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.togglePart(predicate, this.value);
        }

        @Generated
        private TogglePart(boolean value) {
            this.value = value;
        }
    }

    public record ItemStack(@NotNull TransformedItemStack itemStack) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.itemStack(predicate, this.itemStack);
        }
    }

    public record Billboard(@NotNull Display.Billboard billboard) implements TrackerUpdateAction
    {
        @Override
        public boolean test(@NotNull RenderedBone bone, @NotNull BonePredicate predicate) {
            return bone.billboard(predicate, this.billboard);
        }
    }
}

