/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kr.toxicity.model.api.config.DebugConfig;
import kr.toxicity.model.api.pack.PackData;
import kr.toxicity.model.api.pack.PackResource;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.util.ListsKt;
import kr.toxicity.model.util.PackGenerator;
import kr.toxicity.model.util.PluginsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lkr/toxicity/model/util/ZipGenerator;", "Lkr/toxicity/model/util/PackGenerator;", "<init>", "()V", "time", "", "file", "Ljava/io/File;", "create", "Lkr/toxicity/model/api/pack/PackData;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "core"})
@SourceDebugExtension(value={"SMAP\nPacks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/ZipGenerator\n+ 2 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n*L\n1#1,107:1\n21#2,2:108\n*S KotlinDebug\n*F\n+ 1 Packs.kt\nkr/toxicity/model/util/ZipGenerator\n*L\n88#1:108,2\n*E\n"})
public final class ZipGenerator
implements PackGenerator {
    private final long time = System.currentTimeMillis();
    @NotNull
    private final File file = new File(PluginsKt.getDATA_FOLDER().getParent(), PluginsKt.getCONFIG().buildFolderLocation() + ".zip");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PackData create(@NotNull PackZipper zipper) {
        Object object;
        Object object2;
        int n;
        OutputStream outputStream;
        Object it;
        Object $this$create_u24lambda_u240;
        Intrinsics.checkNotNullParameter(zipper, "zipper");
        ConcurrentHashMap map = new ConcurrentHashMap();
        Object object3 = this;
        try {
            $this$create_u24lambda_u240 = object3;
            boolean bl = false;
            $this$create_u24lambda_u240 = Result.constructor-impl(MessageDigest.getInstance("SHA-1"));
        }
        catch (Throwable bl) {
            $this$create_u24lambda_u240 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object3 = $this$create_u24lambda_u240;
        if (Result.isSuccess-impl(object3)) {
            it = (MessageDigest)object3;
            boolean bl = false;
            outputStream = new FileOutputStream(this.file);
            n = 8192;
            object2 = Result.constructor-impl(new DigestOutputStream(outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n), (MessageDigest)it));
        } else {
            object2 = Result.constructor-impl(object3);
        }
        object3 = object2;
        Throwable throwable = Result.exceptionOrNull-impl(object3);
        if (throwable == null) {
            object = object3;
        } else {
            it = throwable;
            boolean bl = false;
            outputStream = new FileOutputStream(this.file);
            n = 8192;
            object = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n);
        }
        OutputStream outputStream2 = (OutputStream)object;
        object3 = new ZipOutputStream(outputStream2);
        Throwable throwable2 = null;
        try {
            ZipOutputStream zip = (ZipOutputStream)object3;
            boolean bl = false;
            zip.setLevel(9);
            zip.setComment("BetterModel's generated resource pack.");
            List<PackResource> list = zipper.build();
            Intrinsics.checkNotNullExpressionValue(list, "build(...)");
            ListsKt.forEachAsync(list, arg_0 -> ZipGenerator.create$lambda$6$lambda$5(map, zip, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, throwable2);
        }
        return new PackData(ListsKt.toImmutableView(map), System.currentTimeMillis() - this.time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit create$lambda$6$lambda$5(ConcurrentHashMap $map, ZipOutputStream $zip, PackResource it) {
        String[] stringArray;
        byte[] result = (byte[])it.get();
        Object object = $map;
        object.put(it.path(), result);
        object = $zip;
        synchronized (object) {
            boolean bl = false;
            $zip.putNextEntry(new ZipEntry(it.path().path()));
            $zip.write(result);
            $zip.closeEntry();
            stringArray = Unit.INSTANCE;
        }
        boolean $i$f$debugPack = false;
        if (PluginsKt.getCONFIG().debug().has(DebugConfig.DebugOption.PACK)) {
            stringArray = new String[1];
            String string = Thread.currentThread().getName();
            int n = 0;
            String[] stringArray2 = stringArray;
            boolean bl = false;
            String string2 = "This file was successfully zipped: " + it.path();
            stringArray2[n] = "[" + string + "] " + string2;
            PluginsKt.info(stringArray);
        }
        return Unit.INSTANCE;
    }
}

