/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.pack;

import java.util.HashMap;
import java.util.Map;
import kr.toxicity.model.api.BetterModel;
import org.jetbrains.annotations.NotNull;

public interface PackObfuscator {
    public static final PackObfuscator NONE = name -> name;

    @NotNull
    public String obfuscate(@NotNull String var1);

    @NotNull
    public static PackObfuscator order() {
        return BetterModel.config().pack().useObfuscation() ? new Order() : NONE;
    }

    @NotNull
    default public Pair withModels(@NotNull PackObfuscator models) {
        return PackObfuscator.pair(models, this);
    }

    @NotNull
    public static Pair pair(@NotNull PackObfuscator models, @NotNull PackObfuscator textures) {
        return new Pair(models, textures);
    }

    public static final class Order
    implements PackObfuscator {
        private static final char[] AVAILABLE_NAME = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'l', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static final int NAME_LENGTH = AVAILABLE_NAME.length;
        private final Map<String, String> nameMap = new HashMap<String, String>();

        private Order() {
        }

        @Override
        @NotNull
        public String obfuscate(@NotNull String rawName) {
            return this.nameMap.computeIfAbsent(rawName, n -> {
                int size;
                StringBuilder builder = new StringBuilder();
                for (size = this.nameMap.size(); size >= NAME_LENGTH; size /= NAME_LENGTH) {
                    builder.append(AVAILABLE_NAME[size % NAME_LENGTH]);
                }
                builder.append(AVAILABLE_NAME[size % NAME_LENGTH]);
                return builder.toString();
            });
        }
    }

    public record Pair(@NotNull PackObfuscator models, @NotNull PackObfuscator textures) {
    }
}

