/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.data.renderer;

import com.mojang.authlib.GameProfile;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.tracker.DummyTracker;
import kr.toxicity.model.api.tracker.EntityTracker;
import kr.toxicity.model.api.tracker.PlayerTracker;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface RenderSource {
    @ApiStatus.Internal
    @NotNull
    public static Located of(@NotNull Location location) {
        return new Dummy(location);
    }

    @ApiStatus.Internal
    @NotNull
    public static Located of(@NotNull Location location, @NotNull GameProfile profile, boolean slim) {
        return new ProfiledDummy(location, profile, slim);
    }

    @ApiStatus.Internal
    @NotNull
    public static Based of(@NotNull Entity entity) {
        Record record;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            record = new BasePlayer(player);
        } else {
            record = new BaseEntity(entity);
        }
        return record;
    }

    @NotNull
    public Tracker create(@NotNull RenderInstance var1, @NotNull TrackerModifier var2);

    public record Dummy(@NotNull Location location) implements Located
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
            return new DummyTracker(this, instance, modifier);
        }
    }

    public record ProfiledDummy(@NotNull Location location, @NotNull GameProfile profile, boolean slim) implements Profiled,
    Located
    {
        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
            return new DummyTracker(this, instance, modifier);
        }
    }

    public static final class BasePlayer
    extends Record
    implements Based,
    Profiled {
        @NotNull
        private final Player entity;

        public BasePlayer(@NotNull Player entity) {
            this.entity = entity;
        }

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
            EntityTracker tracker = EntityTracker.tracker(this.entity.getUniqueId());
            if (tracker != null) {
                tracker.close();
            }
            return new PlayerTracker(this, instance, modifier);
        }

        @Override
        @NotNull
        public GameProfile profile() {
            return BetterModel.plugin().nms().profile(this.entity);
        }

        @Override
        public boolean slim() {
            PlayerChannelHandler channel = BetterModel.plugin().playerManager().player(this.entity.getUniqueId());
            return channel != null && channel.isSlim();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BasePlayer.class, "entity", "entity"}, this, o);
        }

        @NotNull
        public Player entity() {
            return this.entity;
        }
    }

    public record BaseEntity(@NotNull Entity entity) implements Based
    {
        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
            EntityTracker tracker = EntityTracker.tracker(this.entity.getUniqueId());
            if (tracker != null) {
                tracker.close();
            }
            return new EntityTracker(this, instance, modifier);
        }
    }

    public static sealed interface Profiled
    extends RenderSource
    permits ProfiledDummy, BasePlayer {
        @NotNull
        public GameProfile profile();

        public boolean slim();
    }

    public static sealed interface Located
    extends RenderSource
    permits Dummy, ProfiledDummy {
        @NotNull
        public Location location();

        @Override
        @NotNull
        public DummyTracker create(@NotNull RenderInstance var1, @NotNull TrackerModifier var2);
    }

    public static sealed interface Based
    extends RenderSource
    permits BaseEntity, BasePlayer {
        @NotNull
        public Entity entity();

        @Override
        @NotNull
        public EntityTracker create(@NotNull RenderInstance var1, @NotNull TrackerModifier var2);
    }
}

