/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.script;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import java.util.function.Supplier;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.script.BlueprintScript;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptProcessor {
    private final SequencedMap<String, PredicatedScript> scriptMap = new LinkedHashMap<String, PredicatedScript>();
    private final Collection<PredicatedScript> scriptView = this.scriptMap.sequencedValues().reversed();
    @Nullable
    private BlueprintScript.ScriptReader currentReader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(@NotNull BlueprintScript script, @NotNull AnimationIterator.Type defaultType, @NotNull AnimationModifier modifier) {
        SequencedMap<String, PredicatedScript> sequencedMap = this.scriptMap;
        synchronized (sequencedMap) {
            AnimationIterator.Type type = modifier.type() != null ? modifier.type() : defaultType;
            String string = script.name();
            String string2 = script.name();
            Supplier<Boolean> supplier = modifier.predicate();
            this.scriptMap.putLast(string, new PredicatedScript(string2, supplier, switch (type) {
                default -> throw new MatchException(null, null);
                case AnimationIterator.Type.PLAY_ONCE -> script.single(modifier.start(), modifier.speedValue());
                case AnimationIterator.Type.LOOP -> script.loop(modifier.start(), modifier.speedValue());
                case AnimationIterator.Type.HOLD_ON_LAST -> script.holdOn(modifier.start(), modifier.speedValue());
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(@NotNull BlueprintScript script, @NotNull AnimationIterator.Type defaultType, @NotNull AnimationModifier modifier) {
        SequencedMap<String, PredicatedScript> sequencedMap = this.scriptMap;
        synchronized (sequencedMap) {
            AnimationIterator.Type type = modifier.type() != null ? modifier.type() : defaultType;
            String string = script.name();
            String string2 = script.name();
            Supplier<Boolean> supplier = modifier.predicate();
            this.scriptMap.replace(string, new PredicatedScript(string2, supplier, switch (type) {
                default -> throw new MatchException(null, null);
                case AnimationIterator.Type.PLAY_ONCE -> script.single(modifier.start(), modifier.speedValue());
                case AnimationIterator.Type.LOOP -> script.loop(modifier.start(), modifier.speedValue());
                case AnimationIterator.Type.HOLD_ON_LAST -> script.holdOn(modifier.start(), modifier.speedValue());
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAnimation(@NotNull String animation) {
        SequencedMap<String, PredicatedScript> sequencedMap = this.scriptMap;
        synchronized (sequencedMap) {
            this.scriptMap.remove(animation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        SequencedMap<String, PredicatedScript> sequencedMap = this.scriptMap;
        synchronized (sequencedMap) {
            boolean check = true;
            Iterator<PredicatedScript> iterator2 = this.scriptView.iterator();
            while (iterator2.hasNext()) {
                PredicatedScript predicatedScript = iterator2.next();
                if (predicatedScript.supplier.get().booleanValue() && check) {
                    check = false;
                    if (predicatedScript.reader.tick()) {
                        iterator2.remove();
                        continue;
                    }
                    this.currentReader = predicatedScript.reader;
                    continue;
                }
                predicatedScript.reader.clear();
            }
            if (check) {
                this.currentReader = null;
            }
        }
    }

    @Nullable
    @Generated
    public BlueprintScript.ScriptReader getCurrentReader() {
        return this.currentReader;
    }

    private record PredicatedScript(@NotNull String name, @NotNull Supplier<Boolean> supplier, @NotNull BlueprintScript.ScriptReader reader) {
    }
}

