/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kr.toxicity.model.api.BetterModel;
import kr.toxicity.model.api.animation.AnimationIterator;
import kr.toxicity.model.api.animation.AnimationModifier;
import kr.toxicity.model.api.bone.BoneTags;
import kr.toxicity.model.api.bone.RenderedBone;
import kr.toxicity.model.api.data.renderer.RenderInstance;
import kr.toxicity.model.api.data.renderer.RenderSource;
import kr.toxicity.model.api.event.CreateEntityTrackerEvent;
import kr.toxicity.model.api.nms.EntityAdapter;
import kr.toxicity.model.api.nms.HitBox;
import kr.toxicity.model.api.nms.HitBoxListener;
import kr.toxicity.model.api.nms.ModelDisplay;
import kr.toxicity.model.api.nms.PacketBundler;
import kr.toxicity.model.api.nms.PlayerChannelHandler;
import kr.toxicity.model.api.script.BlueprintScript;
import kr.toxicity.model.api.script.EntityScript;
import kr.toxicity.model.api.tracker.ModelRotation;
import kr.toxicity.model.api.tracker.Tracker;
import kr.toxicity.model.api.tracker.TrackerModifier;
import kr.toxicity.model.api.util.BonePredicate;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.EventUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import kr.toxicity.model.api.util.MathUtil;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EntityTracker
extends Tracker {
    private static final Map<UUID, EntityTracker> TRACKER_MAP = new ConcurrentHashMap<UUID, EntityTracker>();
    private static final Collection<EntityTracker> TRACKERS_VIEW = Collections.unmodifiableCollection(TRACKER_MAP.values());
    @NotNull
    private final Entity entity;
    @NotNull
    private final EntityAdapter adapter;
    private final AtomicBoolean autoSpawn = new AtomicBoolean(true);
    private final AtomicInteger damageTintValue = new AtomicInteger(0xFF7979);
    private final AtomicLong damageTint = new AtomicLong(-1L);

    @NotNull
    public UUID world() {
        return this.entity.getWorld().getUID();
    }

    @Nullable
    public static EntityTracker tracker(@NotNull Entity entity) {
        EntityTracker t = EntityTracker.tracker(entity.getUniqueId());
        if (t == null) {
            String tag = (String)entity.getPersistentDataContainer().get(TRACKING_ID, PersistentDataType.STRING);
            if (tag == null) {
                return null;
            }
            return BetterModel.model(tag).map(renderer -> renderer.create(entity)).orElse(null);
        }
        return t;
    }

    @NotNull
    public static @Unmodifiable Collection<EntityTracker> trackers() {
        return TRACKERS_VIEW;
    }

    @Nullable
    public static EntityTracker tracker(@NotNull UUID uuid) {
        return TRACKER_MAP.get(uuid);
    }

    @ApiStatus.Internal
    public static void reload() {
        for (EntityTracker value : new ArrayList<EntityTracker>(TRACKER_MAP.values())) {
            Entity target = value.entity;
            BetterModel.plugin().scheduler().task(target, () -> {
                String name;
                try (EntityTracker entityTracker = value;){
                    if (value.forRemoval()) {
                        return;
                    }
                    name = value.name();
                }
                catch (Exception e) {
                    return;
                }
                BetterModel.model(name).ifPresent(renderer -> renderer.create(target, value.modifier()).spawnNearby());
            });
        }
    }

    @ApiStatus.Internal
    public EntityTracker(@NotNull RenderSource.Based source, @NotNull RenderInstance instance, @NotNull TrackerModifier modifier) {
        super(source, instance, modifier);
        this.entity = source.entity();
        this.adapter = BetterModel.plugin().nms().adapt(this.entity);
        Supplier<Float> scale = FunctionUtil.throttleTick(() -> Float.valueOf(modifier.scale().get().floatValue() * (float)this.adapter.scale()));
        if (modifier.shadow()) {
            ModelDisplay shadow = BetterModel.plugin().nms().create(this.entity.getLocation());
            float baseScale = (float)instance.bones().stream().filter(b -> b.getGroup().getParent().visibility()).map(b -> b.getGroup().getHitBox()).filter(Objects::nonNull).mapToDouble(b -> Math.max(b.box().x(), b.box().z())).max().orElse(0.0);
            this.tick((t, b) -> {
                shadow.shadowRadius(((Float)scale.get()).floatValue() * baseScale);
                shadow.sync(this.adapter);
                shadow.sendEntityData((PacketBundler)b);
                shadow.syncPosition(this.adapter, (PacketBundler)b);
            });
            instance.spawnPacketHandler(shadow::spawn);
            instance.despawnPacketHandler(shadow::remove);
            instance.hidePacketHandler(b -> shadow.sendEntityData(false, (PacketBundler)b));
            instance.showPacketHandler(shadow::sendEntityData);
        }
        instance.defaultPosition(FunctionUtil.throttleTick(() -> this.adapter.passengerPosition().mul(-1.0f)));
        instance.scale(scale);
        Function<Quaternionf, Quaternionf> headRotator = r -> r.mul((Quaternionfc)MathUtil.toQuaternion(new Vector3f(this.adapter.pitch(), -this.adapter.yaw() + this.adapter.bodyYaw(), 0.0f)));
        instance.addRotationModifier(BonePredicate.of(BonePredicate.State.NOT_SET, r -> r.getName().tagged(BoneTags.HEAD)), headRotator);
        instance.addRotationModifier(BonePredicate.of(BonePredicate.State.TRUE, r -> r.getName().tagged(BoneTags.HEAD_WITH_CHILDREN)), headRotator);
        Supplier<Float> damageTickProvider = FunctionUtil.throttleTick(this.adapter::damageTick);
        Supplier<Boolean> walkSupplier = FunctionUtil.throttleTick(() -> this.adapter.onWalk() || (double)((Float)damageTickProvider.get()).floatValue() > 0.25 || instance.bones().stream().anyMatch(e -> {
            HitBox hitBox = e.getHitBox();
            return hitBox != null && hitBox.onWalk();
        }));
        Supplier<Float> walkSpeedSupplier = FunctionUtil.throttleTick(modifier.damageAnimation() ? () -> Float.valueOf(this.adapter.walkSpeed() + 4.0f * (float)Math.sqrt(((Float)damageTickProvider.get()).floatValue())) : () -> Float.valueOf(1.0f));
        instance.animate("walk", new AnimationModifier(walkSupplier, 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        instance.animate("idle_fly", new AnimationModifier(this.adapter::fly, 6, 0, AnimationIterator.Type.LOOP, 1.0f));
        instance.animate("walk_fly", new AnimationModifier(() -> this.adapter.fly() && (Boolean)walkSupplier.get() != false, 6, 0, AnimationIterator.Type.LOOP, walkSpeedSupplier));
        instance.animate("spawn", AnimationModifier.DEFAULT_WITH_PLAY_ONCE);
        TRACKER_MAP.put(this.entity.getUniqueId(), this);
        BetterModel.plugin().scheduler().task(this.entity, () -> {
            if (this.isClosed()) {
                return;
            }
            this.entity.getPersistentDataContainer().set(TRACKING_ID, PersistentDataType.STRING, (Object)instance.getParent().getParent().name());
            this.createHitBox();
        });
        this.tick((t, b) -> this.updateBaseEntity0());
        this.tick((t, b) -> {
            BlueprintScript.ScriptReader reader = t.instance.getScriptProcessor().getCurrentReader();
            if (reader == null) {
                return;
            }
            EntityScript script = reader.script();
            if (script == null) {
                return;
            }
            BetterModel.plugin().scheduler().task(this.entity, () -> script.accept(this.entity));
        });
        this.tick(2L, (t, b) -> {
            if (this.adapter.dead() && !this.forRemoval()) {
                this.close();
            }
        });
        this.frame((t, b) -> {
            if (this.damageTint.getAndDecrement() == 0L) {
                this.tint(0xFFFFFF);
            }
        });
        this.rotation(() -> this.adapter.dead() ? instance.getRotation() : new ModelRotation(0.0f, this.entity instanceof LivingEntity ? this.adapter.bodyYaw() : this.entity.getYaw()));
        this.update();
        EventUtil.call(new CreateEntityTrackerEvent(this));
    }

    private void createHitBox() {
        this.createHitBox(e -> e.getName().name().equals("hitbox") || e.getName().tagged(BoneTags.HITBOX) || e.getGroup().getMountController().canMount());
    }

    private void createHitBox(@NotNull Predicate<RenderedBone> predicate) {
        this.createHitBox(predicate, HitBoxListener.EMPTY);
    }

    public void updateBaseEntity() {
        BetterModel.plugin().scheduler().taskLater(1L, this.entity, () -> {
            this.updateBaseEntity0();
            this.forceUpdate(true);
        });
    }

    private void updateBaseEntity0() {
        this.displays().forEach(d -> d.sync(this.adapter));
    }

    public void createHitBox(@NotNull Predicate<RenderedBone> predicate, @NotNull HitBoxListener listener) {
        this.instance.createHitBox(this.adapter, predicate, listener);
    }

    public int damageTintValue() {
        return this.damageTintValue.get();
    }

    public void damageTintValue(int tint) {
        this.damageTintValue.set(tint);
    }

    public void damageTint() {
        if (!this.modifier().damageTint()) {
            return;
        }
        long get = this.damageTint.get();
        if (get <= 0L && this.damageTint.compareAndSet(get, 50L)) {
            this.tint(this.damageTintValue.get());
        }
    }

    @Override
    public void close() {
        this.instance.allPlayer().forEach(p -> p.endTrack(this));
        super.close();
        TRACKER_MAP.remove(this.entity.getUniqueId());
        this.entity.getPersistentDataContainer().remove(TRACKING_ID);
        Entity entity = this.entity;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.updateInventory();
        }
    }

    @Override
    public void despawn() {
        if (this.adapter.dead()) {
            this.close();
            return;
        }
        this.instance.allPlayer().forEach(p -> p.endTrack(this));
        super.despawn();
    }

    @Override
    @NotNull
    public Location location() {
        return this.entity.getLocation();
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.entity.getUniqueId();
    }

    public boolean autoSpawn() {
        return this.autoSpawn.get();
    }

    public void autoSpawn(boolean spawn) {
        this.autoSpawn.set(spawn);
    }

    @NotNull
    public Entity sourceEntity() {
        return this.entity;
    }

    public void spawnNearby() {
        this.spawnNearby(this.location());
    }

    public void spawnNearby(@NotNull Location location) {
        Predicate<Player> filter = this.instance.spawnFilter();
        for (Entity e : location.getWorld().getNearbyEntities(location, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE, EntityUtil.RENDER_DISTANCE)) {
            Player player;
            if (!(e instanceof Player) || !filter.test(player = (Player)e)) continue;
            this.spawn(player);
        }
    }

    public boolean canBeSpawnedAt(@NotNull Player player) {
        return this.autoSpawn() && this.instance.spawnFilter().test(player);
    }

    public void moveDuration(int duration) {
        this.instance.moveDuration(duration);
        this.forceUpdate(true);
    }

    public boolean spawn(@NotNull Player player) {
        PacketBundler bundler = this.instance.createBundler();
        if (!this.spawn(player, bundler)) {
            return false;
        }
        BetterModel.plugin().nms().mount(this, bundler);
        bundler.send(player, () -> BetterModel.plugin().nms().hide(player, this.entity));
        PlayerChannelHandler handler = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (handler != null) {
            handler.startTrack(this);
        }
        return true;
    }

    @Override
    public boolean remove(@NotNull Player player) {
        if (!super.remove(player)) {
            return false;
        }
        PlayerChannelHandler handler = BetterModel.plugin().playerManager().player(player.getUniqueId());
        if (handler != null) {
            handler.endTrack(this);
        }
        return true;
    }

    @ApiStatus.Internal
    public void refresh() {
        BetterModel.plugin().scheduler().task(this.entity, () -> this.instance.createHitBox(this.adapter, r -> r.getHitBox() != null, null));
    }

    @Override
    public boolean hide(@NotNull Player player) {
        boolean success = super.hide(player);
        if (success) {
            BetterModel.plugin().scheduler().task((Entity)player, () -> player.hideEntity((Plugin)BetterModel.plugin(), this.entity));
        }
        return success;
    }

    @Override
    public boolean show(@NotNull Player player) {
        boolean success = super.show(player);
        if (success) {
            BetterModel.plugin().scheduler().task((Entity)player, () -> player.showEntity((Plugin)BetterModel.plugin(), this.entity));
        }
        return success;
    }

    @NotNull
    @Generated
    public EntityAdapter getAdapter() {
        return this.adapter;
    }
}

