/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.tracker;

import java.util.Objects;
import java.util.function.Supplier;
import kr.toxicity.model.api.util.EntityUtil;
import kr.toxicity.model.api.util.FunctionUtil;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public record TrackerModifier(@NotNull Supplier<Float> scale, boolean sightTrace, boolean damageAnimation, boolean damageTint, float viewRange, boolean shadow, @NotNull HideOption hideOption) {
    public static final TrackerModifier DEFAULT = new TrackerModifier(FunctionUtil.asSupplier(Float.valueOf(1.0f)), true, true, true, EntityUtil.ENTITY_MODEL_VIEW_RADIUS, true, HideOption.DEFAULT);

    @NotNull
    public static Builder builder() {
        return DEFAULT.toBuilder();
    }

    @NotNull
    public Builder toBuilder() {
        return new Builder(this);
    }

    public record HideOption(boolean equipment, boolean fire, boolean visibility, boolean glowing) {
        public static final HideOption DEFAULT = new HideOption(true, true, true, true);

        @Generated
        public static HideOptionBuilder builder() {
            return new HideOptionBuilder();
        }

        @Generated
        public static class HideOptionBuilder {
            @Generated
            private boolean equipment;
            @Generated
            private boolean fire;
            @Generated
            private boolean visibility;
            @Generated
            private boolean glowing;

            @Generated
            HideOptionBuilder() {
            }

            @Generated
            public HideOptionBuilder equipment(boolean equipment) {
                this.equipment = equipment;
                return this;
            }

            @Generated
            public HideOptionBuilder fire(boolean fire) {
                this.fire = fire;
                return this;
            }

            @Generated
            public HideOptionBuilder visibility(boolean visibility) {
                this.visibility = visibility;
                return this;
            }

            @Generated
            public HideOptionBuilder glowing(boolean glowing) {
                this.glowing = glowing;
                return this;
            }

            @Generated
            public HideOption build() {
                return new HideOption(this.equipment, this.fire, this.visibility, this.glowing);
            }

            @Generated
            public String toString() {
                return "TrackerModifier.HideOption.HideOptionBuilder(equipment=" + this.equipment + ", fire=" + this.fire + ", visibility=" + this.visibility + ", glowing=" + this.glowing + ")";
            }
        }
    }

    public static final class Builder {
        private Supplier<Float> scale;
        private boolean sightTrace;
        private boolean damageAnimation;
        private boolean damageTint;
        private float viewRange;
        private boolean shadow;
        private HideOption hideOption;

        private Builder(@NotNull TrackerModifier modifier) {
            this.scale = modifier.scale;
            this.sightTrace = modifier.sightTrace;
            this.damageAnimation = modifier.damageAnimation;
            this.damageTint = modifier.damageTint;
            this.viewRange = modifier.viewRange;
            this.shadow = modifier.shadow;
            this.hideOption = modifier.hideOption;
        }

        @NotNull
        public Builder scale(@NotNull Supplier<Float> scale) {
            this.scale = Objects.requireNonNull(scale, "scale cannot be null.");
            return this;
        }

        @NotNull
        public Builder sightTrace(boolean sightTrace) {
            this.sightTrace = sightTrace;
            return this;
        }

        @NotNull
        public Builder damageAnimation(boolean damageAnimation) {
            this.damageAnimation = damageAnimation;
            return this;
        }

        @NotNull
        public Builder damageTint(boolean damageTint) {
            this.damageTint = damageTint;
            return this;
        }

        @NotNull
        public Builder viewRange(float viewRange) {
            this.viewRange = viewRange;
            return this;
        }

        @NotNull
        public Builder shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        @NotNull
        public Builder hideOption(@NotNull HideOption option) {
            this.hideOption = Objects.requireNonNull(option);
            return this;
        }

        @NotNull
        public TrackerModifier build() {
            return new TrackerModifier(this.scale, this.sightTrace, this.damageAnimation, this.damageTint, this.viewRange, this.shadow, this.hideOption);
        }
    }
}

