/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class FunctionUtil {
    private FunctionUtil() {
        throw new RuntimeException();
    }

    @NotNull
    public static <T> Supplier<T> asSupplier(@NotNull T t) {
        return () -> t;
    }

    @NotNull
    public static Runnable throttleTick(@NotNull Runnable runnable) {
        TickThrottledRunnable throttledRunnable;
        return runnable instanceof TickThrottledRunnable ? (throttledRunnable = (TickThrottledRunnable)runnable) : new TickThrottledRunnable(runnable);
    }

    @NotNull
    public static <T> Supplier<T> throttleTick(@NotNull Supplier<T> supplier) {
        TickThrottledSupplier<T> tickThrottledSupplier;
        if (supplier instanceof TickThrottledSupplier) {
            TickThrottledSupplier throttledSupplier = (TickThrottledSupplier)supplier;
            tickThrottledSupplier = throttledSupplier;
        } else {
            tickThrottledSupplier = new TickThrottledSupplier<T>(supplier);
        }
        return tickThrottledSupplier;
    }

    @NotNull
    public static <T> Predicate<T> throttleTick(@NotNull Predicate<T> predicate) {
        TickThrottledPredicate<T> tickThrottledPredicate;
        if (predicate instanceof TickThrottledPredicate) {
            TickThrottledPredicate throttledSupplier = (TickThrottledPredicate)predicate;
            tickThrottledPredicate = throttledSupplier;
        } else {
            tickThrottledPredicate = new TickThrottledPredicate<T>(predicate);
        }
        return tickThrottledPredicate;
    }

    @NotNull
    public static <T, R> Function<T, R> throttleTick(@NotNull Function<T, R> function) {
        TickThrottledFunction<T, R> tickThrottledFunction;
        if (function instanceof TickThrottledFunction) {
            TickThrottledFunction throttledFunction = (TickThrottledFunction)function;
            tickThrottledFunction = throttledFunction;
        } else {
            tickThrottledFunction = new TickThrottledFunction<T, R>(function);
        }
        return tickThrottledFunction;
    }

    private static class TickThrottledRunnable
    implements Runnable {
        @NotNull
        private final Runnable delegate;
        private final AtomicLong time = new AtomicLong(-51L);

        @Override
        public void run() {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.delegate.run();
            }
        }

        @Generated
        public TickThrottledRunnable(@NotNull Runnable delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledSupplier<T>
    implements Supplier<T> {
        @NotNull
        private final Supplier<T> delegate;
        private final AtomicLong time = new AtomicLong(-51L);
        private volatile T cache;

        @Override
        public T get() {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.get();
            }
            return this.cache;
        }

        @Generated
        public TickThrottledSupplier(@NotNull Supplier<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledPredicate<T>
    implements Predicate<T> {
        @NotNull
        private final Predicate<T> delegate;
        private final AtomicLong time = new AtomicLong(-51L);
        private volatile boolean cache;

        @Override
        public boolean test(T t) {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.test(t);
            }
            return this.cache;
        }

        @Generated
        public TickThrottledPredicate(@NotNull Predicate<T> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }

    private static class TickThrottledFunction<T, R>
    implements Function<T, R> {
        @NotNull
        private final Function<T, R> delegate;
        private final AtomicLong time = new AtomicLong(-51L);
        private volatile R cache;

        @Override
        public R apply(T t) {
            long old = this.time.get();
            long current = System.currentTimeMillis();
            if (current - old >= 50L && this.time.compareAndSet(old, current)) {
                this.cache = this.delegate.apply(t);
            }
            return this.cache;
        }

        @Generated
        public TickThrottledFunction(@NotNull Function<T, R> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }
    }
}

