/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.api.util;

import java.util.List;
import kr.toxicity.model.api.animation.VectorPoint;
import kr.toxicity.model.api.util.VectorUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public enum VectorInterpolation {
    LINEAR{

        @Override
        @NotNull
        public VectorPoint interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            VectorPoint p1 = p2Index > 0 ? points.get(p2Index - 1) : VectorPoint.EMPTY;
            VectorPoint p2 = points.get(p2Index);
            return new VectorPoint(VectorUtil.linear(p1.vector(), p2.vector(), VectorUtil.alpha(p1.time(), p2.time(), time)), time, this);
        }
    }
    ,
    CATMULLROM{

        @NotNull
        private VectorPoint indexOf(@NotNull List<VectorPoint> list, int index, int relative) {
            int i = index + relative;
            if (i < 0) {
                i += list.size();
            } else if (i >= list.size()) {
                i = list.getFirst().time() <= 0.0f ? i % (list.size() - 1) + 1 : i % list.size();
            }
            return list.get(i);
        }

        @Override
        @NotNull
        public VectorPoint interpolate(@NotNull List<VectorPoint> points, int p2Index, float time) {
            if (points.size() < 4) {
                return LINEAR.interpolate(points, p2Index, time);
            }
            VectorPoint p0 = this.indexOf(points, p2Index, -2);
            VectorPoint p1 = this.indexOf(points, p2Index, -1);
            VectorPoint p2 = points.get(p2Index);
            VectorPoint p3 = this.indexOf(points, p2Index, 1);
            return new VectorPoint(VectorUtil.catmull_rom(p0.vector(), p1.vector(), p2.vector(), p3.vector(), VectorUtil.alpha(p1.time(), p2.time(), time)), time, this);
        }
    };


    @NotNull
    public abstract VectorPoint interpolate(@NotNull List<VectorPoint> var1, int var2, float var3);

    @NotNull
    public static VectorInterpolation find(@Nullable String name) {
        if (name == null) {
            return LINEAR;
        }
        try {
            return VectorInterpolation.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return LINEAR;
        }
    }
}

