/*
 * Decompiled with CFR 0.152.
 */
package kr.toxicity.model.manager;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kr.toxicity.model.api.pack.PackObfuscator;
import kr.toxicity.model.api.pack.PackZipper;
import kr.toxicity.model.manager.ArmorManager;
import kr.toxicity.model.manager.GlobalManager;
import kr.toxicity.model.manager.ReloadPipeline;
import kr.toxicity.model.shaded.kotlin.Metadata;
import kr.toxicity.model.shaded.kotlin.Result;
import kr.toxicity.model.shaded.kotlin.ResultKt;
import kr.toxicity.model.shaded.kotlin.Unit;
import kr.toxicity.model.shaded.kotlin.collections.CollectionsKt;
import kr.toxicity.model.shaded.kotlin.collections.MapsKt;
import kr.toxicity.model.shaded.kotlin.collections.SetsKt;
import kr.toxicity.model.shaded.kotlin.comparisons.ComparisonsKt;
import kr.toxicity.model.shaded.kotlin.io.ByteStreamsKt;
import kr.toxicity.model.shaded.kotlin.io.CloseableKt;
import kr.toxicity.model.shaded.kotlin.io.FilesKt;
import kr.toxicity.model.shaded.kotlin.io.path.PathsKt;
import kr.toxicity.model.shaded.kotlin.jvm.functions.Function1;
import kr.toxicity.model.shaded.kotlin.jvm.internal.Intrinsics;
import kr.toxicity.model.shaded.kotlin.jvm.internal.SourceDebugExtension;
import kr.toxicity.model.shaded.kotlin.ranges.RangesKt;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorByteBuilder;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorImage;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorModel;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorNameMapper;
import kr.toxicity.model.shaded.kr.toxicity.library.armormodel.ArmorPaletteImage;
import kr.toxicity.model.util.PluginsKt;
import kr.toxicity.model.util.SendersKt;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007+,-./01B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002J$\u0010\u0016\u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J$\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d*\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u000e\u0010&\u001a\u0004\u0018\u00010'*\u00020(H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010**\u00020(H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00062"}, d2={"Lkr/toxicity/model/manager/ArmorManager;", "Lkr/toxicity/model/manager/GlobalManager;", "<init>", "()V", "ARMOR_PATH", "", "ARMOR_PATH_LEGGINGS", "ARMOR_TRIM_PATH", "ARMOR_TRIM_PATH_LEGGINGS", "ARMOR_PALETTE_PATH", "armors", "", "palettes", "trims", "value", "Lkr/toxicity/model/shaded/kr/toxicity/library/armormodel/ArmorModel;", "armor", "getArmor", "()Lkr/toxicity/model/shaded/kr/toxicity/library/armormodel/ArmorModel;", "downloadMinecraftClient", "Ljava/util/concurrent/CompletableFuture;", "Lkr/toxicity/model/manager/ArmorManager$MinecraftClient;", "loadArmorImage", "Lkr/toxicity/model/manager/ArmorManager$ArmorImageCache;", "Ljava/util/jar/JarFile;", "name", "armorPath", "leggingsPath", "loadImage", "", "kr.toxicity.model.shaded.kotlin.jvm.PlatformType", "path", "reload", "", "pipeline", "Lkr/toxicity/model/manager/ReloadPipeline;", "zipper", "Lkr/toxicity/model/api/pack/PackZipper;", "toArmorImage", "Lkr/toxicity/model/shaded/kr/toxicity/library/armormodel/ArmorImage;", "Ljava/io/File;", "toPaletteImage", "Lkr/toxicity/model/shaded/kr/toxicity/library/armormodel/ArmorPaletteImage;", "VersionManifest", "ManifestLatest", "ManifestVersion", "VersionHash", "HashDownload", "MinecraftClient", "ArmorImageCache", "core"})
@SourceDebugExtension(value={"SMAP\nArmorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmorManager.kt\nkr/toxicity/model/manager/ArmorManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Files.kt\nkr/toxicity/model/util/FilesKt\n+ 4 Senders.kt\nkr/toxicity/model/util/SendersKt\n+ 5 Senders.kt\nkr/toxicity/model/util/SendersKt$toComponent$1\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 Plugins.kt\nkr/toxicity/model/util/PluginsKt\n+ 8 Files.kt\nkr/toxicity/model/util/FilesKt$getOrCreateDirectory$1\n*L\n1#1,257:1\n1#2:258\n17#3,4:259\n22#3:275\n17#3,4:287\n22#3:292\n30#4:263\n49#4,4:264\n30#5:268\n1869#6,2:269\n1869#6,2:271\n1869#6,2:273\n1056#6:276\n1056#6:277\n1056#6:278\n1869#6,2:279\n1208#6,2:293\n1236#6,4:295\n53#7,3:281\n53#7,3:284\n17#8:291\n*S KotlinDebug\n*F\n+ 1 ArmorManager.kt\nkr/toxicity/model/manager/ArmorManager\n*L\n195#1:259,4\n195#1:275\n126#1:287,4\n126#1:292\n196#1:263\n196#1:264,4\n196#1:268\n202#1:269,2\n203#1:271,2\n204#1:273,2\n216#1:276\n220#1:277\n224#1:278\n232#1:279,2\n135#1:293,2\n135#1:295,4\n248#1:281,3\n254#1:284,3\n126#1:291\n*E\n"})
public final class ArmorManager
implements GlobalManager {
    @NotNull
    public static final ArmorManager INSTANCE = new ArmorManager();
    @NotNull
    private static final String ARMOR_PATH = "assets/minecraft/textures/entity/equipment/humanoid";
    @NotNull
    private static final String ARMOR_PATH_LEGGINGS = "assets/minecraft/textures/entity/equipment/humanoid_leggings";
    @NotNull
    private static final String ARMOR_TRIM_PATH = "assets/minecraft/textures/trims/entity/humanoid";
    @NotNull
    private static final String ARMOR_TRIM_PATH_LEGGINGS = "assets/minecraft/textures/trims/entity/humanoid_leggings";
    @NotNull
    private static final String ARMOR_PALETTE_PATH = "assets/minecraft/textures/trims/color_palettes";
    @NotNull
    private static final Set<String> armors;
    @NotNull
    private static final Set<String> palettes;
    @NotNull
    private static final Set<String> trims;
    @NotNull
    private static ArmorModel armor;

    private ArmorManager() {
    }

    @NotNull
    public final ArmorModel getArmor() {
        return armor;
    }

    private final CompletableFuture<MinecraftClient> downloadMinecraftClient() {
        CompletableFuture completableFuture = PluginsKt.httpClient(ArmorManager::downloadMinecraftClient$lambda$0).orElse(ArmorManager::downloadMinecraftClient$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"orElse(...)");
        return completableFuture;
    }

    private final ArmorImageCache loadArmorImage(JarFile $this$loadArmorImage, String name, String armorPath, String leggingsPath) {
        byte[] byArray = this.loadImage($this$loadArmorImage, armorPath, name);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"loadImage(...)");
        byte[] byArray2 = this.loadImage($this$loadArmorImage, leggingsPath, name);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"loadImage(...)");
        return new ArmorImageCache(name, byArray, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] loadImage(JarFile $this$loadImage, String path, String name) {
        byte[] byArray;
        Closeable closeable = $this$loadImage.getInputStream(new ZipEntry(path + "/" + name + ".png"));
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byArray = it.readAllBytes();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void reload(@NotNull ReloadPipeline pipeline, @NotNull PackZipper zipper) {
        Iterable $this$sortedBy$iv;
        Object it;
        void $this$getOrCreateDirectory$iv;
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        Intrinsics.checkNotNullParameter((Object)zipper, (String)"zipper");
        if (!PluginsKt.getPLUGIN().version().useModernResource() || !PluginsKt.getCONFIG().module().playerAnimation()) {
            ArmorModel armorModel = ArmorModel.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)armorModel, (String)"EMPTY");
            armor = armorModel;
            return;
        }
        File file = PluginsKt.getDATA_FOLDER();
        String name$iv = "armors";
        boolean $i$f$getOrCreateDirectory = false;
        Object object = new File((File)$this$getOrCreateDirectory$iv, name$iv);
        File target$iv = object;
        boolean bl = false;
        if (!target$iv.exists()) {
            Component[] componentArray;
            TextComponent.Builder builder;
            target$iv.mkdirs();
            it = target$iv;
            boolean bl2 = false;
            Component[] componentArray2 = new Component[1];
            String $this$toComponent_u24default$iv = "Downloading client jar...";
            boolean $i$f$toComponent = false;
            String content$iv$iv = $this$toComponent_u24default$iv;
            boolean $i$f$componentOf = false;
            boolean $i$f$componentOf2 = false;
            TextComponent.Builder $this$componentOf_u24lambda_u241$iv$iv = SendersKt.componentOf();
            boolean bl3 = false;
            TextComponent.Builder builder2 = $this$componentOf_u24lambda_u241$iv$iv.content(content$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"content(...)");
            TextComponent.Builder builder3 = builder2;
            int n = 0;
            Component[] componentArray3 = componentArray2;
            boolean bl4 = false;
            TextComponent.Builder builder4 = builder = builder3;
            BuildableComponent buildableComponent = builder4.build();
            Intrinsics.checkNotNullExpressionValue((Object)buildableComponent, (String)"build(...)");
            componentArray3[n] = (TextComponent)buildableComponent;
            PluginsKt.info(componentArray2);
            File armorsFile = new File((File)it, "armors");
            File trimsFile = new File((File)it, "armor_trims");
            Component[] $this$reload_u24lambda_u240_u240 = componentArray = new File((File)it, "palettes");
            boolean bl5 = false;
            $this$reload_u24lambda_u240_u240.mkdirs();
            Component[] palettesFile = componentArray;
            MinecraftClient minecraftClient = INSTANCE.downloadMinecraftClient().join();
            if (minecraftClient != null) {
                MinecraftClient client = minecraftClient;
                boolean bl6 = false;
                Closeable closeable = new JarFile(client.getFile());
                Throwable throwable = null;
                try {
                    String name;
                    JarFile jar = (JarFile)closeable;
                    boolean bl7 = false;
                    Iterable $this$forEach$iv = armors;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        name = (String)element$iv;
                        boolean bl8 = false;
                        INSTANCE.loadArmorImage(jar, name, ARMOR_PATH, ARMOR_PATH_LEGGINGS).write(armorsFile);
                    }
                    $this$forEach$iv = trims;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        name = (String)element$iv;
                        boolean bl9 = false;
                        INSTANCE.loadArmorImage(jar, name, ARMOR_TRIM_PATH, ARMOR_TRIM_PATH_LEGGINGS).write(trimsFile);
                    }
                    $this$forEach$iv = palettes;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        name = (String)element$iv;
                        boolean bl10 = false;
                        byte[] image = INSTANCE.loadImage(jar, ARMOR_PALETTE_PATH, name);
                        boolean bl11 = false;
                        File file2 = new File((File)palettesFile, name + ".png");
                        Intrinsics.checkNotNull((Object)image);
                        FilesKt.writeBytes((File)file2, (byte[])image);
                    }
                    builder3 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            componentArray = new Component[1];
            NamedTextColor namedTextColor = NamedTextColor.LIGHT_PURPLE;
            Intrinsics.checkNotNullExpressionValue((Object)namedTextColor, (String)"LIGHT_PURPLE");
            componentArray[0] = SendersKt.toComponent("Download success!", (TextColor)namedTextColor);
            PluginsKt.info(componentArray);
        }
        File folder = object;
        PackObfuscator packObfuscator = PackObfuscator.order();
        Intrinsics.checkNotNullExpressionValue((Object)packObfuscator, (String)"order(...)");
        PackObfuscator textures = packObfuscator;
        PackObfuscator packObfuscator2 = PackObfuscator.order();
        Intrinsics.checkNotNullExpressionValue((Object)packObfuscator2, (String)"order(...)");
        PackObfuscator models = packObfuscator2;
        object = pipeline.mapParallel(kr.toxicity.model.util.FilesKt.subFiles(new File(folder, "armors")), reload.2.INSTANCE, ArmorManager::reload$lambda$2);
        boolean $i$f$sortedBy = false;
        ArmorModel.Builder builder = ArmorModel.builder().namespace(PluginsKt.getCONFIG().namespace()).streamLoader(ArmorManager::reload$lambda$1).armors(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ArmorImage it = (ArmorImage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.name());
                it = (ArmorImage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.name())));
            }
        }));
        $this$sortedBy$iv = pipeline.mapParallel(kr.toxicity.model.util.FilesKt.subFiles(new File(folder, "armor_trims")), reload.5.INSTANCE, ArmorManager::reload$lambda$4);
        $i$f$sortedBy = false;
        ArmorModel.Builder builder5 = builder.armorTrims(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ArmorImage it = (ArmorImage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.name());
                it = (ArmorImage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.name())));
            }
        }));
        $this$sortedBy$iv = pipeline.mapParallel(kr.toxicity.model.util.FilesKt.subFiles(new File(folder, "palettes")), reload.8.INSTANCE, ArmorManager::reload$lambda$6);
        $i$f$sortedBy = false;
        ArmorModel armorModel = builder5.palettes(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ArmorPaletteImage it = (ArmorPaletteImage)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.name());
                it = (ArmorPaletteImage)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.name())));
            }
        })).nameMapper(new ArmorNameMapper(arg_0 -> ArmorManager.reload$lambda$8(textures, arg_0), arg_0 -> ArmorManager.reload$lambda$9(models, arg_0))).flush(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)armorModel, (String)"build(...)");
        armor = armorModel;
        List<ArmorByteBuilder> list = armor.builders();
        Intrinsics.checkNotNullExpressionValue(list, (String)"builders(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (ArmorByteBuilder)element$iv;
            boolean bl12 = false;
            zipper.modern().add(it.path(), 256L, () -> ArmorManager.reload$lambda$10$0((ArmorByteBuilder)it));
        }
    }

    private final ArmorImage toArmorImage(File $this$toArmorImage) {
        Object object;
        Object object2;
        block2: {
            Throwable throwable;
            Object $this$toArmorImage_u24lambda_u240;
            object2 = $this$toArmorImage;
            try {
                $this$toArmorImage_u24lambda_u240 = object2;
                boolean bl = false;
                $this$toArmorImage_u24lambda_u240 = Result.constructor-impl((Object)new ArmorImage(FilesKt.getNameWithoutExtension((File)$this$toArmorImage_u24lambda_u240), kr.toxicity.model.util.FilesKt.toImage(new File((File)$this$toArmorImage_u24lambda_u240, "armor.png")), kr.toxicity.model.util.FilesKt.toImage(new File((File)$this$toArmorImage_u24lambda_u240, "leggings.png"))));
            }
            catch (Throwable throwable2) {
                $this$toArmorImage_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object $this$handleFailure$iv = $this$toArmorImage_u24lambda_u240;
            boolean $i$f$handleFailure = false;
            object = $this$handleFailure$iv;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it$iv = throwable = throwable3;
            boolean bl = false;
            Throwable throwable4 = it$iv;
            boolean bl2 = false;
            PluginsKt.handleException(throwable4, "Unable to load this armor image: " + $this$toArmorImage.getPath());
        }
        return (ArmorImage)(Result.isFailure-impl((Object)(object2 = object)) ? null : object2);
    }

    private final ArmorPaletteImage toPaletteImage(File $this$toPaletteImage) {
        Object object;
        Object object2;
        block2: {
            Throwable throwable;
            Object $this$toPaletteImage_u24lambda_u240;
            object2 = $this$toPaletteImage;
            try {
                $this$toPaletteImage_u24lambda_u240 = object2;
                boolean bl = false;
                $this$toPaletteImage_u24lambda_u240 = Result.constructor-impl((Object)new ArmorPaletteImage(FilesKt.getNameWithoutExtension((File)$this$toPaletteImage_u24lambda_u240), kr.toxicity.model.util.FilesKt.toImage((File)$this$toPaletteImage_u24lambda_u240)));
            }
            catch (Throwable throwable2) {
                $this$toPaletteImage_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Object $this$handleFailure$iv = $this$toPaletteImage_u24lambda_u240;
            boolean $i$f$handleFailure = false;
            object = $this$handleFailure$iv;
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it$iv = throwable = throwable3;
            boolean bl = false;
            Throwable throwable4 = it$iv;
            boolean bl2 = false;
            PluginsKt.handleException(throwable4, "Unable to load this palette image: " + $this$toPaletteImage.getPath());
        }
        return (ArmorPaletteImage)(Result.isFailure-impl((Object)(object2 = object)) ? null : object2);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture downloadMinecraftClient$lambda$0(HttpClient $this$httpClient) {
        void $this$getOrCreateDirectory_u24default$iv;
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$httpClient, (String)"$this$httpClient");
        File file2 = PluginsKt.getDATA_FOLDER();
        String name$iv = ".cache";
        boolean $i$f$getOrCreateDirectory = false;
        File target$iv = file = new File((File)$this$getOrCreateDirectory_u24default$iv, name$iv);
        boolean bl = false;
        if (!target$iv.exists()) {
            target$iv.mkdirs();
            File file3 = target$iv;
            boolean bl2 = false;
            File it = file3;
        }
        File cacheFolder = file;
        return $this$httpClient.sendAsync(PluginsKt.buildHttpRequest((Function1<? super HttpRequest.Builder, Unit>)((Function1)ArmorManager::downloadMinecraftClient$lambda$0$0)), HttpResponse.BodyHandlers.ofInputStream()).thenComposeAsync(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$2(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1(cacheFolder, $this$httpClient, arg_0), arg_0));
    }

    private static final Unit downloadMinecraftClient$lambda$0$0(HttpRequest.Builder $this$buildHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHttpRequest, (String)"$this$buildHttpRequest");
        $this$buildHttpRequest.GET();
        $this$buildHttpRequest.uri(URI.create("https://piston-meta.mojang.com/mc/game/version_manifest_v2.json"));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletionStage downloadMinecraftClient$lambda$0$1(File $cacheFolder, HttpClient $this_httpClient, HttpResponse response1) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNull((Object)response1);
        VersionManifest $this$downloadMinecraftClient_u24lambda_u240_u241_u240 = PluginsKt.toJson(response1, VersionManifest.class);
        boolean bl = false;
        Iterable $this$associateBy$iv = $this$downloadMinecraftClient_u24lambda_u240_u241_u240.getVersions();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ManifestVersion manifestVersion = (ManifestVersion)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            map.put(it.getId(), element$iv$iv);
        }
        Object v = destination$iv$iv.get($this$downloadMinecraftClient_u24lambda_u240_u241_u240.getLatest().getRelease());
        Intrinsics.checkNotNull(v);
        ManifestVersion manifest = (ManifestVersion)v;
        File cache = new File($cacheFolder, manifest.getId() + ".jar");
        return cache.exists() && cache.length() > 0L ? CompletableFuture.supplyAsync(() -> ArmorManager.downloadMinecraftClient$lambda$0$1$1(manifest, cache)) : $this_httpClient.sendAsync(PluginsKt.buildHttpRequest((Function1<? super HttpRequest.Builder, Unit>)((Function1)arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$2(manifest, arg_0))), HttpResponse.BodyHandlers.ofInputStream()).thenComposeAsync(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$4(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$3($this_httpClient, cache, manifest, arg_0), arg_0));
    }

    private static final MinecraftClient downloadMinecraftClient$lambda$0$1$1(ManifestVersion $manifest, File $cache) {
        return new MinecraftClient($manifest.getId(), $cache);
    }

    private static final Unit downloadMinecraftClient$lambda$0$1$2(ManifestVersion $manifest, HttpRequest.Builder $this$buildHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHttpRequest, (String)"$this$buildHttpRequest");
        $this$buildHttpRequest.GET();
        $this$buildHttpRequest.uri(URI.create($manifest.getUrl()));
        return Unit.INSTANCE;
    }

    private static final CompletionStage downloadMinecraftClient$lambda$0$1$3(HttpClient $this_httpClient, File $cache, ManifestVersion $manifest, HttpResponse response2) {
        Intrinsics.checkNotNull((Object)response2);
        VersionHash hash = PluginsKt.toJson(response2, VersionHash.class);
        return $this_httpClient.sendAsync(PluginsKt.buildHttpRequest((Function1<? super HttpRequest.Builder, Unit>)((Function1)arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$3$0(hash, arg_0))), HttpResponse.BodyHandlers.ofInputStream()).thenComposeAsync(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$3$2(arg_0 -> ArmorManager.downloadMinecraftClient$lambda$0$1$3$1($cache, $manifest, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit downloadMinecraftClient$lambda$0$1$3$0(VersionHash $hash, HttpRequest.Builder $this$buildHttpRequest) {
        void $this$downloadMinecraftClient_u24lambda_u240_u241_u243_u240_u240;
        Intrinsics.checkNotNullParameter((Object)$this$buildHttpRequest, (String)"$this$buildHttpRequest");
        $this$buildHttpRequest.GET();
        VersionHash versionHash = $hash;
        HttpRequest.Builder builder = $this$buildHttpRequest;
        boolean bl = false;
        HashDownload hashDownload = $this$downloadMinecraftClient_u24lambda_u240_u241_u243_u240_u240.getDownloads().get("client");
        Intrinsics.checkNotNull((Object)hashDownload);
        builder.uri(URI.create(hashDownload.getUrl()));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final CompletionStage downloadMinecraftClient$lambda$0$1$3$1(File $cache, ManifestVersion $manifest, HttpResponse response3) {
        File temp = PathsKt.createTempFile((Path)$cache.getParentFile().toPath(), (String)$manifest.getId(), (String)".tmp", (FileAttribute[])new FileAttribute[0]).toFile();
        Closeable closeable = (Closeable)response3.body();
        Throwable throwable = null;
        try {
            long l;
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)temp);
            Closeable closeable2 = new FileOutputStream(temp);
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Intrinsics.checkNotNull((Object)input);
            InputStream inputStream = input;
            Throwable throwable2 = null;
            try {
                Closeable p0 = closeable2;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)p0, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        temp.renameTo($cache);
        return CompletableFuture.supplyAsync(() -> ArmorManager.downloadMinecraftClient$lambda$0$1$3$1$1($manifest, $cache));
    }

    private static final MinecraftClient downloadMinecraftClient$lambda$0$1$3$1$1(ManifestVersion $manifest, File $cache) {
        return new MinecraftClient($manifest.getId(), $cache);
    }

    private static final CompletionStage downloadMinecraftClient$lambda$0$1$3$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletionStage downloadMinecraftClient$lambda$0$1$4(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletionStage downloadMinecraftClient$lambda$0$2(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletableFuture downloadMinecraftClient$lambda$1(Exception it) {
        return CompletableFuture.completedFuture(null);
    }

    private static final InputStream reload$lambda$1(String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = PluginsKt.getPLUGIN().getResource(path);
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    private static final ArmorImage reload$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.toArmorImage(it);
    }

    private static final ArmorImage reload$lambda$4(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.toArmorImage(it);
    }

    private static final ArmorPaletteImage reload$lambda$6(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.toPaletteImage(it);
    }

    private static final String reload$lambda$8(PackObfuscator $textures, String it) {
        return $textures.obfuscate(it);
    }

    private static final String reload$lambda$9(PackObfuscator $models, String it) {
        return $models.obfuscate(it);
    }

    private static final byte[] reload$lambda$10$0(ArmorByteBuilder $it) {
        return (byte[])$it.get();
    }

    static {
        Object[] objectArray = new String[]{"chainmail", "copper", "diamond", "gold", "iron", "leather", "netherite"};
        armors = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"amethyst", "copper", "copper_darker", "diamond", "diamond_darker", "emerald", "gold", "gold_darker", "iron", "iron_darker", "lapis", "netherite", "netherite_darker", "quartz", "redstone", "resin"};
        palettes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"bolt", "coast", "dune", "eye", "flow", "host", "raiser", "rib", "sentry", "shaper", "silence", "snout", "spire", "tide", "vex", "ward", "wayfinder", "wild"};
        trims = SetsKt.setOf((Object[])objectArray);
        ArmorModel armorModel = ArmorModel.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)armorModel, (String)"EMPTY");
        armor = armorModel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/model/manager/ArmorManager$ArmorImageCache;", "", "name", "", "armor", "", "leggings", "<init>", "(Ljava/lang/String;[B[B)V", "getName", "()Ljava/lang/String;", "getArmor", "()[B", "getLeggings", "write", "", "target", "Ljava/io/File;", "core"})
    @SourceDebugExtension(value={"SMAP\nArmorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmorManager.kt\nkr/toxicity/model/manager/ArmorManager$ArmorImageCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
    private static final class ArmorImageCache {
        @NotNull
        private final String name;
        @NotNull
        private final byte[] armor;
        @NotNull
        private final byte[] leggings;

        public ArmorImageCache(@NotNull String name, @NotNull byte[] armor, @NotNull byte[] leggings) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Intrinsics.checkNotNullParameter((Object)leggings, (String)"leggings");
            this.name = name;
            this.armor = armor;
            this.leggings = leggings;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final byte[] getArmor() {
            return this.armor;
        }

        @NotNull
        public final byte[] getLeggings() {
            return this.leggings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void write(@NotNull File target) {
            BufferedOutputStream it;
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Object object = new File(target, this.name);
            File $this$write_u24lambda_u240 = object;
            boolean bl = false;
            $this$write_u24lambda_u240.mkdirs();
            File file = object;
            object = new FileOutputStream(new File(file, "armor.png"));
            int n = 8192;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            Throwable throwable = null;
            try {
                it = (BufferedOutputStream)object;
                boolean bl2 = false;
                it.write(this.armor);
                it = Unit.INSTANCE;
            }
            catch (Throwable bl2) {
                throwable = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = new FileOutputStream(new File(file, "leggings.png"));
            int n2 = 8192;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n2);
            Throwable throwable2 = null;
            try {
                it = (BufferedOutputStream)object;
                boolean bl3 = false;
                it.write(this.leggings);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/model/manager/ArmorManager$HashDownload;", "", "url", "", "<init>", "(Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class HashDownload {
        @NotNull
        private final String url;

        public HashDownload(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final HashDownload copy(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new HashDownload(url);
        }

        public static /* synthetic */ HashDownload copy$default(HashDownload hashDownload, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = hashDownload.url;
            }
            return hashDownload.copy(string);
        }

        @NotNull
        public String toString() {
            return "HashDownload(url=" + this.url + ")";
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HashDownload)) {
                return false;
            }
            HashDownload hashDownload = (HashDownload)other;
            return Intrinsics.areEqual((Object)this.url, (Object)hashDownload.url);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkr/toxicity/model/manager/ArmorManager$ManifestLatest;", "", "release", "", "<init>", "(Ljava/lang/String;)V", "getRelease", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class ManifestLatest {
        @NotNull
        private final String release;

        public ManifestLatest(@NotNull String release) {
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            this.release = release;
        }

        @NotNull
        public final String getRelease() {
            return this.release;
        }

        @NotNull
        public final String component1() {
            return this.release;
        }

        @NotNull
        public final ManifestLatest copy(@NotNull String release) {
            Intrinsics.checkNotNullParameter((Object)release, (String)"release");
            return new ManifestLatest(release);
        }

        public static /* synthetic */ ManifestLatest copy$default(ManifestLatest manifestLatest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = manifestLatest.release;
            }
            return manifestLatest.copy(string);
        }

        @NotNull
        public String toString() {
            return "ManifestLatest(release=" + this.release + ")";
        }

        public int hashCode() {
            return this.release.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManifestLatest)) {
                return false;
            }
            ManifestLatest manifestLatest = (ManifestLatest)other;
            return Intrinsics.areEqual((Object)this.release, (Object)manifestLatest.release);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lkr/toxicity/model/manager/ArmorManager$ManifestVersion;", "", "id", "", "url", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class ManifestVersion {
        @NotNull
        private final String id;
        @NotNull
        private final String url;

        public ManifestVersion(@NotNull String id, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.id = id;
            this.url = url;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final ManifestVersion copy(@NotNull String id, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new ManifestVersion(id, url);
        }

        public static /* synthetic */ ManifestVersion copy$default(ManifestVersion manifestVersion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = manifestVersion.id;
            }
            if ((n & 2) != 0) {
                string2 = manifestVersion.url;
            }
            return manifestVersion.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ManifestVersion(id=" + this.id + ", url=" + this.url + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.url.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ManifestVersion)) {
                return false;
            }
            ManifestVersion manifestVersion = (ManifestVersion)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)manifestVersion.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)manifestVersion.url);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lkr/toxicity/model/manager/ArmorManager$MinecraftClient;", "", "version", "", "file", "Ljava/io/File;", "<init>", "(Ljava/lang/String;Ljava/io/File;)V", "getVersion", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class MinecraftClient {
        @NotNull
        private final String version;
        @NotNull
        private final File file;

        public MinecraftClient(@NotNull String version, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.version = version;
            this.file = file;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        @NotNull
        public final String component1() {
            return this.version;
        }

        @NotNull
        public final File component2() {
            return this.file;
        }

        @NotNull
        public final MinecraftClient copy(@NotNull String version, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new MinecraftClient(version, file);
        }

        public static /* synthetic */ MinecraftClient copy$default(MinecraftClient minecraftClient, String string, File file, int n, Object object) {
            if ((n & 1) != 0) {
                string = minecraftClient.version;
            }
            if ((n & 2) != 0) {
                file = minecraftClient.file;
            }
            return minecraftClient.copy(string, file);
        }

        @NotNull
        public String toString() {
            return "MinecraftClient(version=" + this.version + ", file=" + this.file + ")";
        }

        public int hashCode() {
            int result = this.version.hashCode();
            result = result * 31 + this.file.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MinecraftClient)) {
                return false;
            }
            MinecraftClient minecraftClient = (MinecraftClient)other;
            if (!Intrinsics.areEqual((Object)this.version, (Object)minecraftClient.version)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)minecraftClient.file);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lkr/toxicity/model/manager/ArmorManager$VersionHash;", "", "downloads", "", "", "Lkr/toxicity/model/manager/ArmorManager$HashDownload;", "<init>", "(Ljava/util/Map;)V", "getDownloads", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class VersionHash {
        @NotNull
        private final Map<String, HashDownload> downloads;

        public VersionHash(@NotNull Map<String, HashDownload> downloads) {
            Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
            this.downloads = downloads;
        }

        @NotNull
        public final Map<String, HashDownload> getDownloads() {
            return this.downloads;
        }

        @NotNull
        public final Map<String, HashDownload> component1() {
            return this.downloads;
        }

        @NotNull
        public final VersionHash copy(@NotNull Map<String, HashDownload> downloads) {
            Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
            return new VersionHash(downloads);
        }

        public static /* synthetic */ VersionHash copy$default(VersionHash versionHash, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = versionHash.downloads;
            }
            return versionHash.copy(map);
        }

        @NotNull
        public String toString() {
            return "VersionHash(downloads=" + this.downloads + ")";
        }

        public int hashCode() {
            return ((Object)this.downloads).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionHash)) {
                return false;
            }
            VersionHash versionHash = (VersionHash)other;
            return Intrinsics.areEqual(this.downloads, versionHash.downloads);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lkr/toxicity/model/manager/ArmorManager$VersionManifest;", "", "latest", "Lkr/toxicity/model/manager/ArmorManager$ManifestLatest;", "versions", "", "Lkr/toxicity/model/manager/ArmorManager$ManifestVersion;", "<init>", "(Lkr/toxicity/model/manager/ArmorManager$ManifestLatest;Ljava/util/List;)V", "getLatest", "()Lkr/toxicity/model/manager/ArmorManager$ManifestLatest;", "getVersions", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "core"})
    private static final class VersionManifest {
        @NotNull
        private final ManifestLatest latest;
        @NotNull
        private final List<ManifestVersion> versions;

        public VersionManifest(@NotNull ManifestLatest latest, @NotNull List<ManifestVersion> versions) {
            Intrinsics.checkNotNullParameter((Object)latest, (String)"latest");
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            this.latest = latest;
            this.versions = versions;
        }

        @NotNull
        public final ManifestLatest getLatest() {
            return this.latest;
        }

        @NotNull
        public final List<ManifestVersion> getVersions() {
            return this.versions;
        }

        @NotNull
        public final ManifestLatest component1() {
            return this.latest;
        }

        @NotNull
        public final List<ManifestVersion> component2() {
            return this.versions;
        }

        @NotNull
        public final VersionManifest copy(@NotNull ManifestLatest latest, @NotNull List<ManifestVersion> versions) {
            Intrinsics.checkNotNullParameter((Object)latest, (String)"latest");
            Intrinsics.checkNotNullParameter(versions, (String)"versions");
            return new VersionManifest(latest, versions);
        }

        public static /* synthetic */ VersionManifest copy$default(VersionManifest versionManifest, ManifestLatest manifestLatest, List list, int n, Object object) {
            if ((n & 1) != 0) {
                manifestLatest = versionManifest.latest;
            }
            if ((n & 2) != 0) {
                list = versionManifest.versions;
            }
            return versionManifest.copy(manifestLatest, list);
        }

        @NotNull
        public String toString() {
            return "VersionManifest(latest=" + this.latest + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            int result = this.latest.hashCode();
            result = result * 31 + ((Object)this.versions).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VersionManifest)) {
                return false;
            }
            VersionManifest versionManifest = (VersionManifest)other;
            if (!Intrinsics.areEqual((Object)this.latest, (Object)versionManifest.latest)) {
                return false;
            }
            return Intrinsics.areEqual(this.versions, versionManifest.versions);
        }
    }
}

